<?php
require_once __DIR__ . '/auth_config.php';
require_once __DIR__ . '/auth_database.php';
require_once __DIR__ . '/auth_utils.php';

// Sesión segura
ini_set('session.cookie_httponly', 1); // evita acceso a la cookie desde JS (mitiga XSS)
ini_set('session.use_strict_mode', 1); // PHP no aceptará IDs de sesión inválidos o inventados (previene session fixation).
if (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') {
    ini_set('session.cookie_secure', 1); //solo si usas HTTPS) → la cookie de sesión solo viaja por HTTPS.
}

session_start();

//print_r($_SESSION);

// --- 2. Validad cookie "Remember Me" si no hay sesion ---
if (empty($_SESSION['usuarioData']) && !empty($_COOKIE[COOKIE_NAME])) {
    $db = new AuthDatabase();
    $token = $_COOKIE[COOKIE_NAME];
    $usuarioData = $db->get_usuario_byToken($token);

    if ($usuarioData) {
        session_regenerate_id(true);
        $_SESSION['usuarioData']    =  $usuarioData;
        $_SESSION['last_activity']  = time();
        $_SESSION['user_agent']     = $_SERVER['HTTP_USER_AGENT'];

//        print_r($usuarioData);
        // ✅ Log acceso remember-me
        registrarLogin($usuarioData['user'], 'remember');        
    } 
    else
    {
        $db->delete_cookie();

        // ✅ Log intento remember-me fallido
        registrarRememberFail();        
    }
    $db->close();
}

// --- 1. Timeout de inactividad ---
if ( ( isset($_SESSION['last_activity']))  && 
     ((time() - $_SESSION['last_activity']) > TIMEOUT_INACTIVIDAD) && 
    (!isset($_SESSION['usuarioData'])) )
{
    if (isset($_SESSION['usuarioData'])) {
        registrarLogout($_SESSION['usuarioData']['user'], 'TIMEOUT');
    }
    // destoy sess
    session_unset();
    session_destroy();
    header("Location: " . LOGIN_URL);
    exit;
}
$_SESSION['last_activity'] = time();


// --- 3. Validar sesion ---
if (!isset($_SESSION['usuarioData'])) {
    header("Location: " . LOGIN_URL);
    exit;
}

// --- 4. Validar User-Agent  ---
if (!isset($_SESSION['user_agent']))
{
    $_SESSION['user_agent'] = $_SERVER['HTTP_USER_AGENT'];
}
elseif ($_SESSION['user_agent'] !== $_SERVER['HTTP_USER_AGENT'])
{
    registrarLogout($_SESSION['usuarioData']['user'], 'LOGOUT change userAgent');
    session_unset();
    session_destroy();
    header("Location: " . LOGIN_URL);
    exit;
}


?>
