<?php
require_once __DIR__ . '/auth_config.php';

class AuthDatabase
{
    public $conexion;

    public function __construct()
    {
        $this->conexion = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME, DB_PORT);
        $this->conexion->select_db(DB_NAME);

        if ($this->conexion->connect_errno) {
            echo "Error de conexión (" . $this->conexion->connect_errno . "): " . $this->conexion->connect_error;
//            die("Error de conexión a MySQL: " . $this->conexion->connect_error);
        }

        // Charset recomendado
        $this->conexion->set_charset("utf8");
    }

    /**
     * Devuelve los datos del usuario si user/pass son correctos
     */
    public function get_usuario($usuario, $password)
    {
        $sql = "SELECT * FROM acl_usuarios WHERE `user` = ? AND pass = ? LIMIT 1";

        $stmt = $this->conexion->prepare($sql);
        if ($stmt === false) {
            die("Error en prepare(): " . $this->conexion->error);
        }

        $passMd5 = md5($password);
        $stmt->bind_param("ss", $usuario, $passMd5);

        if (!$stmt->execute()) {
            die("Error al ejecutar SQL: " . $stmt->error);
        }

        $result = $stmt->get_result();
        $data   = $result->fetch_assoc();

        $stmt->close();

        if ($data && isset($data['pass'])) {
            unset($data['pass']); // nunca exponer el hash
        }

        return $data;
    }

    /**
     * Busca usuario por token (para auto-login con “Recuérdame”)
     */
    public function get_usuario_byToken($token)
    {
        $tokenHash = hash('sha256', $token); // generamos hash del token recibido

        $sql = "SELECT * FROM acl_usuarios WHERE remember_token = ? LIMIT 1";
        $stmt = $this->conexion->prepare($sql);

        if ($stmt === false) {
            die("Error en prepare(): " . $this->conexion->error);
        }

        $stmt->bind_param("s", $tokenHash);

        if (!$stmt->execute()) {
            die("Error al ejecutar SQL: " . $stmt->error);
        }

        $result = $stmt->get_result();
        $data   = $result->fetch_assoc();
        $stmt->close();

        if ($data && isset($data['pass'])) {
            unset($data['pass']);
        }

        return $data;
    }



    /**
     * Actualiza el remember_token de un usuario
     */
    public function update_rememberToken($usuarioId, $token)
    {
        $sql = "UPDATE acl_usuarios SET remember_token = ? WHERE id = ?";
//        echo $sql." ".$usuarioId." ".$token;

        $stmt = $this->conexion->prepare($sql);

        if ($stmt === false) {
            die("Error en prepare(): " . $this->conexion->error);
        }

        $stmt->bind_param("si", $token, $usuarioId);

        $ok = $stmt->execute();
        $stmt->close();

        return $ok;
    }


    /**
     * Cierra la conexión 
     */
    public function close()
    {
        $this->conexion->close();
    }

    function create_token( $usuarioId )
    {
        $token = bin2hex(openssl_random_pseudo_bytes(32)); // Token aleatorio
        $tokenHash = hash('sha256', $token);


        $this->update_rememberToken($usuarioId, $tokenHash);
        return $token;
    }

    function create_cookie( $token )
    {
        $secure = !empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off';
        // $secure = false; // solo para desarrollo si no usas HTTPS

        setcookie(COOKIE_NAME, $token, time() + (TOKEN_DIAS * 24 * 60 * 60), '/', '', $secure, true);
    }

    function delete_token( $usuarioId )
    {
        $this->update_rememberToken($usuarioId, '');
    }

    function delete_cookie(  )
    {
        // expira el token del navegador
        setcookie ( COOKIE_NAME, "", time() - 3600, "/", "", false, true);
        unset($_COOKIE[COOKIE_NAME]);
    }


}
