<?
require_once __DIR__ . '/auth_database.php';

function registrarLogin($user, $metodo = 'password') {
    try
    {

    
    $db = new AuthDatabase();

    $ip = isset($_SERVER['REMOTE_ADDR']) ? $_SERVER['REMOTE_ADDR'] : 'desconocido';    
    if (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        $ip = explode(',', $_SERVER['HTTP_X_FORWARDED_FOR'])[0];
    }

    $user_agent = isset($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT'] : 'desconocido';
    $session_hash = hash('sha256', session_id());
    $fecha_login = date('Y-m-d H:i:s');


    /*
    echo $user;
    echo $fecha_login;
    echo $ip;
    echo $user_agent;
    echo $metodo;
    echo $session_hash;
    */

    $stmt = $db->conexion->prepare("INSERT INTO acl_log_accesos
        (user, fecha_login, ip, user_agent, resultado, metodo, session_hash)
        VALUES (?, ?, ?, ?, 'OK', ?, ?)");
    $stmt->bind_param("ssssss", $user, $fecha_login, $ip, $user_agent, $metodo, $session_hash);
    $stmt->execute();
    $stmt->close();
    $db->close();
        }
        catch (Exception $e)
        {
            echo $e->getMessage();
        }

}

function registrarLogout($user, $motivo = 'LOGOUT') {
    $db = new AuthDatabase();

    $session_hash = hash('sha256', session_id());
    $fecha_logout = date('Y-m-d H:i:s');

    $stmt = $db->conexion->prepare("UPDATE acl_log_accesos
        SET fecha_logout = ?, resultado = ?
        WHERE session_hash = ? AND fecha_logout IS NULL");
    $stmt->bind_param("sss", $fecha_logout, $motivo, $session_hash);
    $stmt->execute();
    $stmt->close();
    $db->close();
}

function registrarLoginFallido($user, $metodo = 'password') {
    $db = new AuthDatabase();

    $ip = isset($_SERVER['REMOTE_ADDR']) ? $_SERVER['REMOTE_ADDR'] : 'desconocido';    
    if (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        $ip = explode(',', $_SERVER['HTTP_X_FORWARDED_FOR'])[0];
    }

    $user_agent = isset($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT'] : 'desconocido';
    $session_hash = hash('sha256', session_id());
    $fecha_login = date('Y-m-d H:i:s');

    $stmt = $db->conexion->prepare("INSERT INTO acl_log_accesos
        (user, fecha_login, fecha_logout, ip, user_agent, resultado, metodo, session_hash)
        VALUES (?, ?, ?, ?, ?, 'FAIL', ?, ?)");
    $fecha_logout = $fecha_login;
    $stmt->bind_param("sssssss", $user, $fecha_login, $fecha_logout, $ip, $user_agent, $metodo, $session_hash);
    $stmt->execute();
    $stmt->close();
    $db->close();
}

function registrarRememberFail() {
    $db = new AuthDatabase();


    $ip = isset($_SERVER['REMOTE_ADDR']) ? $_SERVER['REMOTE_ADDR'] : 'desconocido';    
    if (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        $ip = explode(',', $_SERVER['HTTP_X_FORWARDED_FOR'])[0];
    }

    $user_agent = isset($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT'] : 'desconocido';
    $session_hash = hash('sha256', session_id());
    $fecha_login = date('Y-m-d H:i:s');

    $stmt = $db->conexion->prepare("INSERT INTO acl_log_accesos
        (user, fecha_login, fecha_logout, ip, user_agent, resultado, metodo, session_hash)
        VALUES ('-1', ?, ?, ?, ?, 'REMEMBER_FAIL', 'remember_me', ?)");
    $fecha_logout = $fecha_login;
    $stmt->bind_param("ssss", $fecha_login, $fecha_logout, $ip, $user_agent, $session_hash);
    $stmt->execute();
    $stmt->close();
    $db->close();
}

?>