<?php
require_once './auth_config.php';
require_once './auth_database.php';
require_once __DIR__ . '/auth_utils.php';

session_start();

// --- Validar login por POST ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $usuario  = isset($_POST['usuario'])  ? trim($_POST['usuario']) : '';
    $password = isset($_POST['password']) ? trim($_POST['password']) : '';

    // Validar que vengan datos
    if ($usuario === '' || $password === '') {
        header("Location: " . LOGIN_URL . "?error=1");
        exit;
    }
}
else
{
    header("Location: " . LOGIN_URL);
    exit;
}

// --- Consulta usuario ---
$db = new AuthDatabase();
$usuarioData = null;
$usuarioData = $db->get_usuario($usuario, $password);

if ($usuarioData)
{
    if (!empty($_POST['remember']))
    {
        $token = $db->create_token( $usuarioData['id'] );
        $db->create_cookie($token);
    }

    // --- Sesión segura ---
    session_regenerate_id(true); // Seguridad
    $_SESSION['usuarioData'] = $usuarioData;
    $_SESSION['last_activity'] = time();
    $_SESSION['user_agent'] = $_SERVER['HTTP_USER_AGENT'];

    // ✅ Log login correcto
    registrarLogin($usuarioData['user'], 'password');
//    die(1);

    $db->close();
    header("Location: " . INDEX_URL);
    exit;
}
else
{
    // ❌ Log login fallido
    registrarLoginFallido($usuario);

    $db->close();
    header("Location: " . LOGIN_URL);
    exit;
}
?>
