<?php
    require_once './auth_config.php';
    require_once './auth_database.php';
    require_once './auth_utils.php';

    session_start();

    $db = new AuthDatabase();
    if (!empty($_SESSION['usuarioData']['id']))
    {    
        $db->delete_token($_SESSION['usuarioData']['id']);
        registrarLogout($_SESSION['usuarioData']['username'], 'LOGOUT');        
    }
    $db->delete_cookie();
    $db->close();

    // destroy session
    session_unset();
    session_destroy();


    // Eliminar cookie de sesión PHP
    if (ini_get("session.use_cookies")) {
        $params = session_get_cookie_params();
        setcookie(session_name(), '', time() - 42000,
            $params["path"], $params["domain"],
            $params["secure"], $params["httponly"]
        );
    }

    // Regenerar ID por seguridad
    session_regenerate_id(true);


    header("Location: " . LOGIN_URL);    
    exit;

?>