<?php 

/**
* 
*/
class Tools
{
	
	public static function debugTXT($texto,$archivo='log.txt'){

		$dir = $_SERVER['DOCUMENT_ROOT'].'/logs/';
        if(!file_exists($dir)){
            mkdir($dir);
        }
    	$fecha = date("Y-m-d H:i:s");
        $file = fopen($dir.$archivo,'a');
        fwrite($file,'['.$fecha.'] ');
        if(is_array($texto)){
        	$resultado = var_export($texto,true);
        	fwrite($file,$resultado.PHP_EOL);
        }else{
        	fwrite($file,$texto.PHP_EOL);	
        }
        
        fclose($file);
    }


    public function ObtenerIP()
    {
        $ip = "";
        if(isset($_SERVER))
        {
            if (!empty($_SERVER['HTTP_CLIENT_IP']))
            {
                $ip=$_SERVER['HTTP_CLIENT_IP'];
            }
            elseif(!empty($_SERVER['HTTP_X_FORWARDED_FOR']))
            {
                $ip=$_SERVER['HTTP_X_FORWARDED_FOR'];
            }
            else
            {
                $ip=$_SERVER['REMOTE_ADDR'];
            }
        }
        else
        {
            if ( getenv( 'HTTP_CLIENT_IP' ) )
            {
                $ip = getenv( 'HTTP_CLIENT_IP' );
            }
            elseif( getenv( 'HTTP_X_FORWARDED_FOR' ) )
            {
                $ip = getenv( 'HTTP_X_FORWARDED_FOR' );
            }
            else
            {
                $ip = getenv( 'REMOTE_ADDR' );
            }
        }
        // En algunos casos muy raros la ip es devuelta repetida dos veces separada por coma
        if(strstr($ip,','))
        {
            $ip = array_shift(explode(',',$ip));
        }
        return $ip;
    }


    public function FormatoMillares($numero, $decimales=2) {
        return number_format(round(($numero),2),$decimales,',','.');
    }

    /**
     * Uso de memoria empleada por el script
     * @param string $unidad
     * @return float|int
     */
    public function UsoMemoria($unidad='') {
        $memoria=memory_get_usage();
        switch(strtoupper($unidad)) {
            case 'M': $memoria=($memoria/1024)/1024;
            case 'K': $memoria=$memoria/1024;
        }
        return $memoria;
    }


    /**
     * Función para calcular el tiempo de ejecucion de un script
     * Uso: al principio del script llamamos a la funcion y al final de la funcion la volvemos a llamar.
     *  Restamos los dos datos dandonos como resultado el tiempo empleado en el script
     * @return float
     */
    public function microtime_float()
    {
        list($useg, $seg) = explode(" ", microtime());
        return ((float)$useg + (float)$seg);
    }

    
}


 ?>