<?php
class AppConfig {
    private static $instance;
    private $config = [];
    
    private function __construct() {}
    
    public static function getInstance() {
        if (!self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    // Método para establecer un array completo con una clave principal
    public function setConfig($key, array $values) {
        $this->config[$key] = $values;
    }
    
    // Método para agregar valores a un array existente
    public function addToConfig($key, array $values) {
        if (!isset($this->config[$key])) {
            $this->config[$key] = [];
        }
        $this->config[$key] = array_merge($this->config[$key], $values);
    }
    
    // Método para obtener todo un array de configuración por su clave
    public function getConfig($key) {
        return isset($this->config[$key]) ? $this->config[$key] : null;
    }
    
    // Método para obtener un valor específico dentro de un array de configuración
    public function get($mainKey, $subKey = null) {
        if (!isset($this->config[$mainKey])) {
            return null;
        }
        
        if ($subKey === null) {
            return $this->config[$mainKey];
        }
        
        return isset($this->config[$mainKey][$subKey]) ? $this->config[$mainKey][$subKey] : null;
    }
}

?>