<?php

class UtilFechas {

    private static $zonaHoraria = 'Europe/Madrid';

    // Método para configurar la zona horaria
    public static function establecerZonaHoraria($zonaHoraria) {
        self::$zonaHoraria = $zonaHoraria;
    }

	public static function get_fechaHoy(){
		date_default_timezone_set(self::$zonaHoraria);

		$fechaHoy = date('Y-m-d');
		return $fechaHoy;
	}

	public static function get_fechaAyer(){
		date_default_timezone_set(self::$zonaHoraria);
		
		$fecha = date('Y-m-d', strtotime('-1 day'));
		return $fecha;
	}

	public static function get_fechaManana(){
		date_default_timezone_set(self::$zonaHoraria);

		$fecha = date('Y-m-d', strtotime('+1 day'));
		return $fecha;
	}

	// es el día anterior a fecha fin
	public static function get_fechafinAyer($fechafin){
		date_default_timezone_set(self::$zonaHoraria);
		
		$fecha = new DateTime($fechafin);
		$fecha->modify('-1 day');

		return $fecha->format('Y-m-d');
	}


	public static function get_rangohoras( $fechaini, $fechafin){
		$array_rangohoras = self::calcularHorasEntreFechas( $fechaini, $fechafin );

		$rangohoras = $array_rangohoras['horas'];
		return $rangohoras;
	}

	public static function get_rangodias ($fechaini, $fechafin){
		$array_rangohoras = self::calcularHorasEntreFechas( $fechaini, $fechafin );

		$rangodias  = round ($array_rangohoras['horas'] / 24, 0 );
		return $rangodias;
	}

	public static function get_fechafinalayer(){
}

	public static function calcularHorasEntreFechas($fechaini, $fechafin) {

		if (!isset($fechaini) || !isset($fechafin) || !strtotime($fechaini) || !strtotime($fechafin)) {
			throw new InvalidArgumentException("Fechas no válidas");
		}
		
		$inicio = new DateTime($fechaini);
		$fin	= new DateTime($fechafin);
		
		if ($check && $inicio > $fin) {
			throw new InvalidArgumentException("La fecha de inicio debe ser anterior a la fecha de fin");
		}
		

		// Calcular la diferencia entre las dos fechas
		$diferencia = $inicio->diff($fin);

		// Convertir la diferencia a horas (considerando días, horas, minutos, etc.)
		$horas = ($diferencia->days * 24) + $diferencia->h;  

		// Si quieres también contar los minutos en la diferencia
		$minutos = $diferencia->i;
    
		// Si deseas un valor con los minutos también convertidos a fracción de hora:
		$horasConMinutos = $horas + ($minutos / 60);
    
		$result = [];
		$result['horas']	= round ((int)$horas, 0);
		$result['minutos']  = round ((int)$minutos, 0);
	
		return $result;
	}


	public static function calcularHorasConSigno($fechaHoy, $fechaIntervention) {
		$fechaHoy = trim($fechaHoy);
		$fechaIntervention = trim($fechaIntervention);
	
		/*
		if (!strtotime($fechaHoy) || !strtotime($fechaIntervention)) {
			throw new InvalidArgumentException("Fechas no válidas");
		}
		*/

		$inicio = new DateTime($fechaHoy);
		$fin    = new DateTime($fechaIntervention);
	
		// Diferencia en segundos (puede ser negativa)
		$diffSegundos = $fin->getTimestamp() - $inicio->getTimestamp();
	
		// Convertir a horas (con signo)
		$horas = $diffSegundos / 3600;
		$dias = $diffSegundos / 86400; // 86400 = segundos en un día

		return round($dias, 2); // puedes ajustar precisión aquí
	}	
}
?>
