<?php

class UtilPaginacion
{
    public static function get_limitOptions()
    {
        $limitOptions =[];
        $limitOptions[] = [ 'id'=> 0, 'value1'=> 5, 'text'=> '5 reg. per page'];
        $limitOptions[] = [ 'id'=> 1, 'value1'=> 10, 'text'=> '10 reg. per page'];
        $limitOptions[] = [ 'id'=> 2, 'value1'=> 30, 'text'=> '30 reg. per page'];
        $limitOptions[] = [ 'id'=> 3, 'value1'=> 100, 'text'=> '100 reg. per page'];

        return $limitOptions;
    }


    public static function getParams_pag($pag_limit_default = 10, $pag_page_default = 1)
    {
        $paginacion = [];
    // Asegúrate de que los valores sean enteros
    $paginacion['page']    = (isset($_GET['pag_page']) && is_numeric($_GET['pag_page'])) 
                             ? intval($_GET['pag_page']) 
                             : $pag_page_default;

    $paginacion['limit']   = (isset($_GET['pag_limit']) && is_numeric($_GET['pag_limit'])) 
                             ? intval($_GET['pag_limit']) 
                             : $pag_limit_default;

//        $paginacion['page']    = (isset($_GET['pag_page']))    ? $_GET['pag_page']    : 1;
//        $paginacion['limit']   = (isset($_GET['pag_limit']))   ? $_GET['pag_limit']   : 10;
        $paginacion['offset']  = ($paginacion['page'] - 1) * $paginacion['limit'];
        
        return $paginacion;
    }

    public static function getParams_sort()
    {
        $sort= [];
        $sort['column']     = (isset($_GET['sort_column']))    ? $_GET['sort_column']    : '';
        $sort['direction']  = (isset($_GET['sort_direction'])) ? $_GET['sort_direction']    : 'ASC';

        return $sort;
    }


    // nueva version, pasamos los links a botones para usar ajax mejor.
    public static function showPaginacion($pag, $numReg)
    {
//        $totalPages = ceil((int)$numReg / $pag['limit']);
        $totalPages = max(1, ceil((int)$numReg / $pag['limit']));   // paga que siempre haya al menos una pag si el numero de registros es cero
    
        // Si estamos en una página que no tiene registros (por ejemplo, la página 5 con solo 2 registros), ajustamos la página
        if ($pag['page'] > $totalPages) {
            $pag['page'] = $totalPages;  // Establecemos la página al último valor posible
        }        
        $maxButtons = 5; // Número máximo de botones de paginación a mostrar
    
//        print_r($pag);


        $html = "<div class='row paginacion'>";
        $html .= "<div class='col-sm-6 my-1 d-flex align-items-center'>";
    
        $start = ($pag['page'] - 1) * $pag['limit'] + 1;
        $end = min($start + $pag['limit'] - 1, $numReg);
        
        // Si no hay registros, ajustar la salida
        if ($numReg == 0) {
            $start = 0;
            $end = 0;
        }


        $html .= "Showing $start-$end of $numReg registers";
        $html .= "</div>";
    
        $html .= "<div class='col-sm-6 d-flex justify-content-end'>";
    
        // Botón "Previous"
        if ($pag['page'] > 1) {
//            $html .= "<a href='index.php?".$queryString."&pag_page=".($pag['page']-1)."' class='mr-2 btn btn-secondary btn-sm btn-create'>Previous</a>";
            $html .= "<button class='mr-2 btn btn-secondary btn-sm btn-create pagination-btn' data-page='".($pag['page']-1)."'>Previous</button>";            
        }
    
        // Calcular rango de botones de paginación
        $half = floor($maxButtons / 2);
        $startPage = max(1, $pag['page'] - $half);
        $endPage = min($totalPages, $startPage + $maxButtons - 1);
    
        // Ajustar si el rango se sale de los límites
        if ($endPage - $startPage + 1 < $maxButtons) {
            $startPage = max(1, $endPage - $maxButtons + 1);
        }
    
        // Botón para ir al inicio si no está incluido
        if ($startPage > 1) {
//            $html .= "<a href='index.php?".$queryString."&pag_page=1' class='mr-2 btn btn-secondary btn-sm btn-create'>1...</a>";
            $html .= "<button class='mr-2 btn btn-secondary btn-sm btn-create pagination-btn' data-page='1'>1...</button>";            
        }
    
        // Botones de página
        for ($i = $startPage; $i <= $endPage; $i++) {
            $class = ($i == $pag['page']) ? "mr-2 btn btn-primary btn-sm btn-create active" : "mr-2 btn btn-secondary btn-sm btn-create";
//            $html .= "<a href='index.php?".$queryString."&pag_page=$i' class='$class'>$i</a>";
            $html .= "<button class='$class pagination-btn' data-page='$i'>$i</button>";            
        }
    
        // Botón para ir al final si no está incluido
        if ($endPage < $totalPages) {
     //       $html .= "<a href='index.php?".$queryString."&pag_page=$totalPages' class='mr-2 btn btn-secondary btn-sm btn-create'>...$totalPages</a>";
            $html .= "<button class='mr-2 btn btn-secondary btn-sm btn-create pagination-btn' data-page='$totalPages'>...$totalPages</button>";
        }
    
        // Botón "Next"
        if ($pag['page'] < $totalPages) {
//            $html .= "<a href='index.php?".$queryString."&pag_page=".($pag['page']+1)."' class='mr-2 btn btn-secondary btn-sm btn-create'>Next</a>";
            $html .= "<button class='mr-2 btn btn-secondary btn-sm btn-create pagination-btn' data-page='".($pag['page']+1)."'>Next</button>";
        }
    
        $html .= "</div>";
        $html .= "</div>";
    
        return $html;
    }



} // class
?>