<?php

class UtilRender
{

    public static function escapeHtml($string) {
        if ($string === null) {
            $string = '';  // Asignamos una cadena vacía si $string es null
        }
        return htmlspecialchars($string, ENT_QUOTES, 'UTF-8');
    }

    public static function renderPage($content) {
        $global = AppConfig::getInstance()->get('global');


        $page = isset($_GET['page']) ? $_GET['page'] : '';
        $num = rand();

        $html = '<html lang="es">
        <head>
            <meta charset="UTF-8"> 
            <!--
            <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
            <meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate" />
            <meta http-equiv="Pragma" content="no-cache" />
            <meta http-equiv="Expires" content="0" />
            ->
            <title>Crane Rental Vouchers</title>
        ';

        $html .= '
            <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Roboto|Varela+Round"> 
            <link rel="stylesheet" href="https://fonts.googleapis.com/icon?family=Material+Icons"> 
            <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css"> 


            <!-- Incluye jQuery antes de Bootstrap JS -->
            <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>

            <!-- jQuery UI -->
            <script src="https://code.jquery.com/ui/1.13.2/jquery-ui.min.js"></script>
            <link rel="stylesheet" href="https://code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">

            <!-- Incluye Bootstrap CSS -->
            <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
            

            <!-- Bootstrap Timepicker CSS -->
            <!-- <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-timepicker/0.5.2/css/bootstrap-timepicker.min.css"> -->

            <!-- Bootstrap Timepicker JS -->
            <!-- <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-timepicker/0.5.2/js/bootstrap-timepicker.min.js"></script> -->

            <link rel="stylesheet" href="//cdnjs.cloudflare.com/ajax/libs/timepicker/1.3.5/jquery.timepicker.min.css">
            <script src="//cdnjs.cloudflare.com/ajax/libs/timepicker/1.3.5/jquery.timepicker.min.js"></script>

            <!-- Incluye Bootstrap JS (con jQuery y Popper.js, necesarios para los modales) -->
            <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.bundle.min.js"></script>

            
            
            <link rel="stylesheet" href="./plugins/flatpickr/flatpickr.css" />
            <script src="./plugins/flatpickr/flatpickr"></script>      

            
            <link rel="stylesheet" href="./plugins/select2/select2.css" />
            <script src="./plugins/select2/select2.js"></script>      

            <script src="./plugins/table2excel/jquery.table2excel.min.js"></script>
            <script src="./plugins/jspdf/jspdf.umd.min.js"></script>
            <script src="./plugins/jspdf/jspdf.plugin.autotable.min.js"></script>

            <!-- <script src="https://cdnjs.cloudflare.com/ajax/libs/dompurify/3.0.6/purify.min.js"></script>   -->        
            <script type="text/javascript" src="/pages/montCRV/kpis/define_listas_estadisticas_dev.js?v=<?php echo rand(); ?>"></script>
        ';


        $html .= '
            <!-- <link rel="stylesheet" href="./css/mont_flatpickr.css?ts=<?php echo $num; ?>" /> -->
            <link rel="stylesheet" href="./css/mont_paginacion.css?ts=<?php echo $num; ?>" />
            <link rel="stylesheet" href="./css/mont_filters.css?ts=<?php echo $num; ?>" />  
            <link rel="stylesheet" href="./css/mont.css?ts=<?php echo $num; ?>" />
            <link rel="stylesheet" href="./css/custom.css?ts=<?php echo $num; ?>" /> 
            <link rel="stylesheet" href="./css/modal.css?ts=<?php echo $num; ?>" /> 
            <link rel="stylesheet" href="./css/maintenance_table.css?ts=<?php echo $num; ?>" /> 
        ';


        $html .= '
            </head>
        ';

        $html .= '<body>';
        $html .= '<div class="container" style="max-width:100%;">';




        // main contain
        if ( $page === 'graficas' ){
            $html .= '<div class="container menuHead" style="max-width:100%;">';
        }
        else {
            $html .= '<div class="container menuHead" style="max-width:95%;">';
        }

        $html .= $content;
        $html .= '</div>';

        $html .=
         '
            <div id="editModal" class="modal" data-backdrop="false">
                <div id="modal-content" class="modal-content" style="width: 98%;" >
                    <div><button id="closeButton" type="button" onclick="hideModal()" class="close btn btn-primary">Save & Return</button></div>
                    <div class="modal-header">
                    <h5 class="modal-title" id="modal-title" iaad="staticBackdropLabel"></h5>
                    </div>                    
                    <div id="modalFormContent">
                    </div>
                </div>
            </div>
        ';
        $html .=
         '
            <div id="maintenanceModal" class="modal modal-maintenance-download" data-backdrop="false">
                <div id="modal-content" class="modal-content" style="width: 98%;" >
                    <div><button id="maintenanceModal_closeButton" type="button" onclick="maintenanceModal_closeButton()" class="close btn btn-primary">Close</button></div>
                    <div class="modal-header">
                        <h5  id="maintenanceModal_title"></h5>
                    </div>                    
                        <div id="maintenanceModal_content">
                    </div>
                </div>
            </div>
        ';
        $html .= '</div>';

        $html .= '
            <div id="spinner-overlay" class="d-none">
                <div class="spinner-border text-primary" role="status">
                    <span class="visually-hidden"></span>
                </div>
            </div>';


        $html .= '</body>';
        $html .= '</html>';

        echo $html; // Imprimir el HTML
    }

    public static function get_topLinks_dev() {
        $topLinks = "<a class='btn filter-btna ' href='./auth/logout.php'>logout</a>";
        $topLinks .= "<a class='btn filter-btna ' href='index.php?page=instalacion'>Instalaciones</a>";
        $topLinks .= "<a class='btn filter-btna ' href='index.php?page=equipos'>Equipos</a>";
        /*
        $topLinks .= "<a class='btn filter-btna ' href='index.php?page=instalacion'>Instalaciones</a>";
//        $topLinks .= "<a class='btn filter-btna ' href='index.php?page=formcrv&formCRV_firstLoad=1'>                    FormCRV</a>";
        $topLinks .= "<a class='btn filter-btna ' href='index.php?page=eventosMiami&eventosMiami_firstLoad=1'>          Alarms</a>";
        $topLinks .= "<a class='btn filter-btna ' href='index.php?page=vesselTracking&vesselTracking_firstLoad=1'>      VesselTracking</a>";
        $topLinks .= "<a class='btn filter-btna ' href='index.php?page=vesselHistory&vesselHistory_firstLoad=1'>        VesselHistory</a>";
        $topLinks .= "<a class='btn filter-btna ' href='index.php?page=maintenance&maintenance_firstLoad=1'>            Maintenance</a>";
        */

        /*
        $topLinks .= "<a class='btn filter-btna ' href='index.php?page=shipline&shipline_firstLoad=1'>                  Shiplines</a>";
        $topLinks .= "<a class='btn filter-btna ' href='index.php?page=stevedore&stevedore_firstLoad=1'>                Stevedore</a>";
        $topLinks .= "<a class='btn filter-btna ' href='index.php?page=form_crv_services&form_crv_services_firstLoad=1'>Services</a>";
        $topLinks .= "<a class='btn filter-btna ' href='index.php?page=barcos&barcos_firstLoad=1'>                      Vessels</a>";
        $topLinks .= "<a class='btn filter-btna ' href='index.php?page=mnt_items&mnt_items_firstLoad=1'>                Maintenance Items</a>";
        $topLinks .= "<a class='btn filter-btna ' href='index.php?page=mnt_items_list&mnt_items_list_firstLoad=1'>                Maintenance Items List</a>";
        */
        $topLinks .= '</div>';

        return $topLinks;
    }




    public static function AddCarboard($table, $title)
    {
        $html = "";
        $html .= "<div class='card p-1 w-100'>";
        $html .=    "<div class='card-header p-0'>";
        $html .=        "<h6 class='mb-1'>".$title."</h6>";
        $html .=    "</div>";

        $html .=    "<div class='card-body p-0'>";
        $html .=     $table;
        $html .=    "</div>";
        $html .= "</div>";

        return $html;
    }




    // sample
    //  <label for='guid_filter'>GUID:</label>"
    //  <input type='text' name='filter_guid' id='guid_filter' value='".UtilRender::escapeHtml($filter_guid)."'>"
    public static function createInputText($name, $value, $label, $id = null)
    {
        if (!isset($id)) { $id = $name; }
    
        $html = "<label for='{$id}'>{$label}:</label>";
        $html .= "<input type='text' name='{$name}' id='{$id}' value='".UtilRender::escapeHtml($value)."'>";
    
        return $html;
    }

    //  <label for='date_filter'>Date To:</label>
    //  <input type='text' name='filter_dateTo' value='".$filter_dateTo. "' class='date-filter' />
    public static function createInputDate($name, $value, $label, $id = null)
    {
        if (!isset($id)) { $id = $name; }

        $html = "<label for='{$id}'>{$label}:</label>";
        $html .= "<input class='date-filter' type='date' name='{$name}' id='{$id}' value='".UtilRender::escapeHtml($value)."'>";

        return $html;
    }


    // esto es para el buscador
    public static function createSelect($name, $label, $options, $selectedValue = null, $id = null, $valueField = 'id', $textField = 'name')
    {
        if (!isset($id)) { $id = $name; }

        $html = "<label for='{$id}'>{$label}:</label>";
        $html .= "<select class='searchable-select' name='{$name}' id='{$id}'>";
        $html .= "<option value='none' selected>"."All"."</option>"; 
        
        foreach ($options as $option)
        {
            $selected = ($option[$valueField] == $selectedValue) ? " selected" : "";
            $html .= "<option value='".self::escapeHtml($option[$valueField])."' {$selected}>".self::escapeHtml($option[$textField])."</option>";
        }
        
        $html .= "</select>";
        
        return $html;
    }    


    // html filter components
    public static function create_filter_date($fieldName, $fieldValue, $label, $id, $class)
    {
        if (!isset($id)) { $id = $fieldName; }

        $html = "";
        $html .= "<div class='{$class}'>";
        $html .=    "<div class='filter-group'>";
        $html .=        "<label style='text-align:left;'>{$label}</label>";
        $html .=        "<input class='date-filter form-co4ntrol' type='date' name='{$fieldName}' id='{$id}' value='".UtilRender::escapeHtml($fieldValue)."'>";
        $html .=    "</div>";
        $html .=  "</div>";

        return $html;
    }


    public static function create_filter_text($fieldName, $fieldValue, $label, $id = null, $class = 'col-sm-2')
    {
        if (!isset($id)) { $id = $fieldName; }
    
        $html = "";
        $html .= "<div class='{$class}'>";
        $html .=    "<div class='filter-group'>";
        $html .=        "<label>{$label}</label>";
        $html .=        "<input type='text' name='{$fieldName}' id='{$id}' value='".UtilRender::escapeHtml($fieldValue)."'>";
        $html .=    "</div>";
        $html .=  "</div>";
    
        return $html;
    }

    
    public static function create_dropdown_editable($data_locked, $data_id, $data_field, $data_action, $options, $valueField, $valueSelected, $textField)
    {
        $class = "dropdown-editable searchable-select dropdown_mont";
        $disabled = "";
        if ($data_locked) { $disabled = " disabled"; }

        $html = "<select class='".$class."' data-id='".UtilRender::escapeHtml($data_id)."' data-field='$data_field' data-action='".UtilRender::escapeHtml($data_action)."' ".$disabled.">";
//        $html .= "<option value='none' selected>"."Unassigned"."</option>"; 
        
        foreach ($options as $option)
        {
            $selected = ($option[$valueField] == $valueSelected) ? " selected" : "";
            $html .= "<option value='".self::escapeHtml($option[$valueField])."' {$selected}>".self::escapeHtml($option[$textField])."</option>";
        }
        $html .= "</select>";
        return $html;
    }    


    public static function create_date_editable($data_locked, $data_id, $data_field, $data_action, $data_value)
    {
        $disabled = "";
        if ($data_locked) { $disabled = " disabled"; }

        $html = "<input type='text' class='date-editable' data-id='".UtilRender::escapeHtml($data_id)."' data-field='".UtilRender::escapeHtml($data_field)."' data-action='".UtilRender::escapeHtml($data_action)."' value='".UtilRender::escapeHtml($data_value)."' ".$disabled." />";

        return $html;
    }    


    // class time-input         actualiza el registro
    // class time-inputTotal    actualiza el registro, y calcula los totales
    public static function create_time_editable($data_idform, $data_locked, $data_id, $data_field, $data_action, $data_value, $class='time-editable')
    {
        $disabled = "";
        if ($data_locked) { $disabled = " disabled"; }

        $html = "<input type='text' class='".$class."' data-idform='".$data_idform."' data-id='".UtilRender::escapeHtml($data_id)."' data-field='".UtilRender::escapeHtml($data_field)."' data-action='".UtilRender::escapeHtml($data_action)."' value='".UtilRender::escapeHtml($data_value)."' ".$disabled." />";

        return $html;
    }    

    public static function create_time_editable24($data_idform, $data_locked, $data_id, $data_field, $data_action, $data_value,  $class='time-editable24')
    {
        $disabled = "";
        if ($data_locked) { $disabled = " disabled"; }

        $html = "<input type='text' class='".$class."' data-idform='".$data_idform."' data-id='".UtilRender::escapeHtml($data_id)."' data-field='".UtilRender::escapeHtml($data_field)."' data-action='".UtilRender::escapeHtml($data_action)."' value='".UtilRender::escapeHtml($data_value)."' data-value='".UtilRender::escapeHtml($data_value)."'".$disabled." />";

        return $html;
    }    

    // class time-input         actualiza el registro
    // class time-inputTotal    actualiza el registro, y calcula los totales
    public static function create_boolean_editable($data_idform, $data_locked, $data_id, $data_field, $data_action, $data_value, $class='boolean-editable')
    {
        $disabled = "";
        if ($data_locked) { $disabled = " disabled"; }
        
        $checked = $data_value ? " checked" : "";

//        $html = "<input type='checkbox' class='".$class."' data-idform='".$data_idform."' data-id='".UtilRender::escapeHtml($data_id)."' data-field='".UtilRender::escapeHtml($data_field)."' data-action='".UtilRender::escapeHtml($data_action)."' value='1'".$checked.$disabled." />";
        $html = "<input type='checkbox' class='".$class."' data-idform='".$data_idform."' data-id='".UtilRender::escapeHtml($data_id)."' data-field='".UtilRender::escapeHtml($data_field)."' data-action='".UtilRender::escapeHtml($data_action)."' value='".UtilRender::escapeHtml($data_value)."' ".$checked.$disabled." />";

        return $html;
    }    



    // class td_editable         actualiza el registro
    // class td_editableTOTAL    actualiza el registro, y calcula los totales
    // campos int, ya que en mont_editables se hace una validacion
    public static function create_td_editable($data_idform, $data_locked, $data_id, $data_field, $data_action, $data_value, $class='td_editable')
    {
        if ($data_locked)
        {
            $html = "<td  class='".$class."' 
                data-idform='".$data_idform."' 
                data-id='".UtilRender::escapeHtml($data_id)."' 
                data-field='".UtilRender::escapeHtml($data_field)."' 
                data-originalvalue='".UtilRender::escapeHtml($data_value)."' 
                data-action='".UtilRender::escapeHtml($data_action)."' >" .UtilRender::escapeHtml( $data_value)."</td>";
        } 
        else
        {
            $html = "<td contenteditable='true' class='".$class."' 
             data-idform='".$data_idform."' 
             data-id='".UtilRender::escapeHtml($data_id)."' 
             data-field='".UtilRender::escapeHtml($data_field)."' 
             data-originalvalue='".UtilRender::escapeHtml($data_value)."' 
             data-action='".UtilRender::escapeHtml($data_action)."' >" .UtilRender::escapeHtml( $data_value)."</td>";
        }

        return $html;
    }    

    public static function create_textarea_editable($data_locked, $data_id, $data_field, $data_action, $data_value)
    {
        $disabled = "";
        if ($data_locked) { $disabled = " disabled"; }

        $html = "<textarea class='textarea-editable celdaTextAreaInTable' data-id='".UtilRender::escapeHtml($data_id)."' data-field='".UtilRender::escapeHtml($data_field)."' data-action='".$data_action."' ".$disabled." >".UtilRender::escapeHtml($data_value)."</textarea>";

        return $html;
    }    

    public static function create_textareaNotes_editable($data_locked, $data_id, $data_field, $data_action, $data_value)
    {
        $disabled = "";
        if ($data_locked) { $disabled = " disabled"; }

        $html = "<textarea class='textarea-editable celdaTextArea' data-id='".UtilRender::escapeHtml($data_id)."' data-field='".UtilRender::escapeHtml($data_field)."' data-action='".$data_action."' ".$disabled." >".UtilRender::escapeHtml($data_value)."</textarea>";

        return $html;
    }    





public static function showHead($text)
{
    $text = util_languages::translate( $text );

    $html = "";
    $html .= "<div class='table-title shadow' 
                 style='background: linear-gradient(to right, #007BFF, #ffffff);
                        display: flex; 
                        align-items: center; 
                        justify-content: flex-start; 
                        min-height: 70px; /* le damos altura */
                        padding: 20px 30px;'>"; 
    $html .=     "<h3 style='margin:10px;'> {$text} </h3>";
    $html .= "</div>";
    
    return $html;
}









} // class
?>