<?php

class UtilSQL
{
    
    public static function build_paginacion($filters, &$params, &$types)
    {
        $sql = "";

        // Validar limit y offset
        $limit  = isset($filters['pag_limit']) && is_numeric($filters['pag_limit']) && $filters['pag_limit'] > 0 ? (int)$filters['pag_limit'] : 10;
        $offset = isset($filters['pag_offset']) && is_numeric($filters['pag_offset']) && $filters['pag_offset'] >= 0 ? (int)$filters['pag_offset'] : 0;

        // Agregar paginación a la consulta
        $sql .= " LIMIT ? OFFSET ?";
        $params[] = $limit;
        $params[] = $offset;
        $types .= "ii";  // `ii` para indicar que ambos parámetros son enteros

        return $sql;
    }

    public static function build_sort($filters)
    {
        $sql = "";

        // Asegurarse de que la columna y dirección sean válidas
        if ($filters['sort_column'] != '' && $filters['sort_direction'] != '') {


                // Asegurarse de que la dirección sea 'ASC' o 'DESC'
                $dir  = strtoupper($filters['sort_direction']) === 'DESC' ? 'DESC' : 'ASC';
                $sql .= " ORDER BY " . $filters['sort_column'] . " " . $dir;
        }

        return $sql;
    }
    

    public static function executeQuery($db, $sql, $params = [], $types = "")
    {
        try {
            $stmt = $db->prepare($sql);

            if ($params) {
                $bindParams = [];
                foreach ($params as $key => $param) {
                    $bindParams[$key] = &$params[$key];  // Crear referencias
                }
                call_user_func_array([$stmt, 'bind_param'], array_merge([$types], $bindParams));
            }

            if (!$stmt->execute()) {
                die('Error en la ejecución de la consulta SQL: ' . $stmt->error);
            }

//            echo  $sql;

            return $stmt;
        } catch (mysqli_sql_exception $e) {
            // Manejar el error de la base de datos
            error_log("Error de SQL: " . $e->getMessage());  // Puedes guardar el error en el log
            throw new Exception("Hubo un problema con la base de datos. Por favor, intenta más tarde.");
        }
    }

}
?>