<?php
/*
spl_autoload_register(function ($class) {
    $baseDir = __DIR__ . '/../'; // autoload esta en core, tenemos que bajar

    // 1. Buscar clases en la raíz (ej: Database.php, Container.php)
    $rootPath = $baseDir . '/' . $class . '.php';
    if (file_exists($rootPath)) {
        require_once $rootPath;
        return;
    }

   // 1. Buscar en core
    $corePath = $baseDir . '/core/' . $class . '.php';
    if (file_exists($corePath)) { require_once $corePath; return; }

    // 2. Buscar en /modules/[modulo]/[clase].php
    if (strpos($class, '_') !== false) {
        $parts = explode('_', $class);
        $module = $parts[0]; // ej: instalacion, equipos

        $file = $baseDir . '/modules/' . $module . '/' . $class . '.php';
        if (file_exists($file)) {
            require_once $file;
            return;
        }
    }
});
*/



spl_autoload_register(function ($class) {
    $baseDir = __DIR__ . '/../';

    // 1. Buscar en raíz
    $rootPath = "$baseDir/$class.php";
    if (file_exists($rootPath)) {
        require_once $rootPath;
        return;
    }

    // 2. Buscar en core
    $corePath = "$baseDir/core/$class.php";
    if (file_exists($corePath)) {
        require_once $corePath;
        return;
    }

    // 3. Buscar en módulos
    // Asume que la carpeta del módulo es la parte antes del último '_'
    if (strpos($class, '_') !== false) {
        $parts = explode('_', $class);
        $type = array_pop($parts); // model, view, controller
        $moduleFolder = implode('_', $parts);

        // Intentar: /modules/[modulo]/[clase].php
        $file = "$baseDir/modules/$moduleFolder/$class.php";
        if (file_exists($file)) {
            require_once $file;
            return;
        }

        // Fallback: intentar solo la primera parte como módulo
        $moduleFolder = $parts[0];
        $file = "$baseDir/modules/$moduleFolder/$class.php";
        if (file_exists($file)) {
            require_once $file;
            return;
        }
    }
});
