<?php
class Container {
    private $services = array();
    private $instances = array();

    public function set($name, $callable) {
        $this->services[$name] = $callable;
    }

    public function get($name) {
        if (!isset($this->instances[$name]))
        {
            if (!isset($this->services[$name]))
            {
                throw new Exception("Servicio {$name} no encontrado en el contenedor");
            }
            $this->instances[$name] = $this->services[$name]($this);
        }
        return $this->instances[$name];
    }
}
