<?php

class util_html_filter
{

    public static function get_limitOptions()
    {
        $limitOptions =[];
        $limitOptions[] = [ 'id'=> 0, 'value1'=> 5, 'text'=> '5 per page'];
        $limitOptions[] = [ 'id'=> 1, 'value1'=> 10, 'text'=> '10 per page'];
        $limitOptions[] = [ 'id'=> 2, 'value1'=> 30, 'text'=> '30 per page'];
        $limitOptions[] = [ 'id'=> 3, 'value1'=> 100, 'text'=> '100 per page'];

        return $limitOptions;
    }

    public static function getParams_pag($P, array $filters)
    {
//        $P = array_merge($_GET, $_POST);
        $pag_limit_default = 10;
        $pag_page_default = 1;

        // Asegúrate de que los valores sean enteros
        $filters['pag_page']    = (isset($P['pag_page']) && is_numeric($P['pag_page'])) 
                             ? intval($P['pag_page']) 
                             : $pag_page_default;

        $filters['pag_limit']   = (isset($P['pag_limit']) && is_numeric($P['pag_limit'])) 
                             ? intval($P['pag_limit']) 
                             : $pag_limit_default;

        $filters['pag_offset']  = ($filters['pag_page'] - 1) * $filters['pag_limit'];
        
        return $filters;
    }

    public static function getParams_sort($P, array $filters)
    {
        $P = array_merge($_GET, $_POST);

        $filters['sort_column']     = (isset($P['sort_column']))    ? $P['sort_column']    : '';
        $filters['sort_direction']  = (isset($P['sort_direction'])) ? $P['sort_direction']    : 'ASC';

        return $filters;
    }


    public static function showPaginacion($filters, $numReg, $action)
    {
        $totalPages = ceil((int)$numReg / $filters['pag_limit']);
        $maxButtons = 5;

        $html = "<div class='row paginacion'>";
        $html .= "<div class='col-sm-6 my-1 d-flex align-items-center'>";
        $start = ($filters['pag_page'] - 1) * $filters['pag_limit'] + 1;
        $end = min($start + $filters['pag_limit'] - 1, $numReg);
        $html .= util_languages::translate('showing') ." ". $start ."-". $end ." ". util_languages::translate('of') ." ". $numReg ." ". util_languages::translate('registers');
        $html .= "</div>";


        $html .= "<div class='col-sm-6 d-flex justify-content-end'>";

        // Botón "Previous"
        if ($filters['pag_page'] > 1) {
            $html .= "<button type='button' class='btn btn-secondary btn-sm mr-2 pagination-btn' data-page='".($filters['pag_page']-1)."'>Previous</button>";
        }

        $half = floor($maxButtons / 2);
        $startPage = max(1, $filters['pag_page'] - $half);
        $endPage = min($totalPages, $startPage + $maxButtons - 1);

        if ($endPage - $startPage + 1 < $maxButtons) {
            $startPage = max(1, $endPage - $maxButtons + 1);
        }

        if ($startPage > 1) {
            $html .= "<button type='button' class='btn btn-secondary btn-sm mr-2 pagination-btn' data-page='1'>1...</button>";
        }

        for ($i = $startPage; $i <= $endPage; $i++) {
            $class = ($i == $filters['pag_page']) ? "btn btn-primary btn-sm mr-2 active pagination-btn" : "btn btn-secondary btn-sm mr-2 pagination-btn";
            $html .= "<button type='button' class='$class' data-page='$i'>$i</button>";
        }

        if ($endPage < $totalPages) {
            $html .= "<button type='button' class='btn btn-secondary btn-sm mr-2 pagination-btn' data-page='$totalPages'>...$totalPages</button>";
        }

        if ($filters['pag_page'] < $totalPages) {
            $html .= "<button type='button' class='btn btn-secondary btn-sm mr-2 pagination-btn' data-page='".($filters['pag_page']+1)."'>Next</button>";
        }

        $html .= "</div>";
        $html .= "</div>";

        return $html;
    }


    // filter types components
    public static function filter_search($id, $value, $label, $class_input, $class_div= '' )
    {
        $label = util_languages::translate($label);

        $html = "";
        $html .= "<div class='{$class_div}'>";
        $html .=    "<div class='filter-group form-group'>";
        $html .=        "<label for='{$id}'>{$label}</label>";
        $html .=        "<div class='input-group'>";
        $html .=        "<input type='text'
                                id='{$id}' 
                                name='{$id}' 
                                class='form-control form-control-sm fa fa-search {$class_input}' 
                                placeholder='Search...'
                                value='".UtilRender::escapeHtml($value)."' >";
                        $html .=        "</div>";
        $html .=    "</div>";
        $html .=  "</div>";
        return $html;
    }


    public static function filter_select($id,  $label, $options, $optionColumnSelected, $optionColumn, $optionColumnText, $class_div, $class_input, $optionAll=true)
    {
        $label = util_languages::translate($label);

        if (!isset($id)) { $id = $name; }

        $html = "";
        $html .= "<div class='{$class_div}'>";
        $html .=    "<div class='filter-group form-group'>";
        $html .=        "<label for='{$id}'>{$label}</label>";
        $html .=        "<select 
                            id='{$id}'
                            name='{$id}' 
                            class='searchable-select form-control form-control-sm {$class_input}' 
                            >";
        if ($optionAll)
        {
            $html .=            "<option value='none' selected>"."All"."</option>"; 
        }

        foreach ($options as $option)
        {
            $selected = ($option[$optionColumn] === $optionColumnSelected) ? " selected" : "";
            $html .=     "<option value='".UtilRender::escapeHtml($option[$optionColumn])."' {$selected}>".UtilRender::escapeHtml($option[$optionColumnText])."</option>";
        }
        $html .=         "</select>";
        $html .=    "</div>";
        $html .=  "</div>";
        
        return $html;
    }    


    // el checkbox pisa al hidden
    public function filter_checkbox($id, $checked, $label, $class = '' ) {
                $label = util_languages::translate($label);

        $isChecked = $checked === 1 ? 'checked' : '';

        $html = "
            <input type='hidden' name='{$id}' value='0'>
            <div class='form-check'>
                <input class='form-check-input {$class}' type='checkbox' 
                    id='{$id}' name='{$id}' value='1' {$isChecked}>
                <label class='form-check-label' for='{$id}'>{$label}</label>
            </div>
        ";

        return $html;
    }


}