<?php

class util_html_form
{

    public static function input_text(
        $field, 
        $value,
        $label, 
        $class='', 
        $style=''
        )
     {

        $label = util_languages::translate($label);

//        $class = "mb-3 w-150";
        $class = "form-control w-100";

        $class_html = " class='form-control text-left' ";
        $style_html = "";
        if (!empty($class)) {$class_html = " class={$class}"; }
        if (!empty($style)) {$style_html = " style={$style}" ; }

    $html  = "<div class='mb-3 d-flex align-items-center' $style_html>";        
    $html .= "  <label for='$field' class='form-label fw-bold me-2' style='min-width:120px;'>$label:</label>";
    $html .= "  <input type='text' id='$field' name='$field' value='$value' $class_html $style_html>";
    $html .= "</div>";         
        return $html;
    }    

    public static function input_text_hidden(
        $field, 
        $value,
        $label, 
        $class='', 
        $style=''
        )
     {

//        $class = "mb-3 w-150";
        $class = "form-control w-100";

        $class_html = " class='form-control text-left' ";
        $style_html = "";
        if (!empty($class)) {$class_html = " class={$class}"; }
        if (!empty($style)) {$style_html = " style={$style}" ; }

    $html  = "<div class='mb-3 d-flex align-items-center'$style_html>";        
    $html .= "  <input type='hidden' id='$field' name='$field' value='$value' $class_html $style_html>";
    $html .= "</div>";         
        return $html;
    }    


    // options[] = ['id' => 0, 'value1' => value1, 'text' => label1 ];
    // options[] = ['id' => 1, 'value1' => value2, 'text' => label2 ];
    public static function select ( 
        $field,
        $label, 
        $options, 
        $optionSelected,
        $class='',
        $style=''
        )
    {
        $label = util_languages::translate($label);

//        print_r($options);
        $class = "form-control w-100";

        $class_html = " class='form-control text-left' ";
        $style_html = "";
        if (!empty($class)) {$class_html = " class={$class}"; }
        if (!empty($style)) {$style_html = " style={$style}" ; }


//        $class = "classdropdown-editable searchable-select dropdown_mont";
        $disabled = "";
//        $disabled = $data_locked ? " disabled" : "";
//        if ($data_locked) { $disabled = " disabled"; }

        $html = "<div class='mb-3 d-flex align-items-center'  $style_html>";        
//        $html = "<div $class $style_html>";        
        $html .= "  <label for='$field' class='form-label fw-bold me-2' style='min-width:120px;'>$label:</label>";

        $html .= "<select 
            $class_html
            name        = '" . UtilRender::escapeHtml($field) . "' 
            id     = '" . UtilRender::escapeHtml($field) ."' 
             " . $disabled . ">";
        
            foreach ($options as $option)
            {
                $selected = (trim(strtolower($option['value1'])) == trim(strtolower($optionSelected)) ) ? " selected" : "";
                $html .= "<option value='" . UtilRender::escapeHtml($option['value1']) . "' {$selected}>".UtilRender::escapeHtml($option['text']) . "</option>";
            }
        $html .= "</select>";
        $html .= "</div>";         

        return $html;
    }    


public static function select44($field, $label, $options, $optionSelected, $class='', $style='')
{
      $label = util_languages::translate($label);
//    $class_html = "class='form-control flex-grow-1 dropdown-editable searchable-select dropdown_mont'";
    $class_html = " class='form-control flex-grow-1' ";
    $style_html = "";
    if (!empty($style)) { $style_html = "style='{$style}'"; }

    $disabled = "";

    $html = "<div class='mb-3 d-flex align-items-center' $style_html>";        
//    $html .= "<label for='$field' class='form-label fw-bold me-2' style='min-width:120px;'>$label:</label>";
    $html .= "<label for='$field' class='form-label' style='min-width:10px;'>$label:</label>";

    $html .= "<select $class_html name='" . UtilRender::escapeHtml($field) . "' id='" . UtilRender::escapeHtml($field) . "' $disabled>";
    
    foreach ($options as $option) {
        $value = trim($option['value1']);
        $selected = (trim(strtolower($optionSelected)) == strtolower($value)) ? "selected" : "";
        $html .= "<option value='" . UtilRender::escapeHtml($value) . "' $selected>" . UtilRender::escapeHtml($option['text']) . "</option>";
    }

    $html .= "</select>";
    $html .= "</div>";         

    return $html;
}


public static function selecsdft($field, $label, $options, $optionSelected, $class='', $style='')
{
    // HTML del contenedor con row + alineación vertical
    $html = "<div class='mb-3 row align-items-center'>";
    
    // Label ocupa ancho mínimo
    $html .= "<label for='" . UtilRender::escapeHtml($field) . "' class='col-auto col-form-label fw-bold'>$label:</label>";
    
    // Contenedor del select ocupa el resto del espacio
    $html .= "<div class='col'>";
    
    // Select con clase form-control de Bootstrap
    $html .= "<select class='form-control' name='" . UtilRender::escapeHtml($field) . "' id='" . UtilRender::escapeHtml($field) . "'>";
    
    // Opciones
    foreach ($options as $option) {
        $value = trim($option['value1']);
        $selected = (trim(strtolower($optionSelected)) == strtolower($value)) ? "selected" : "";
        $html .= "<option value='" . UtilRender::escapeHtml($value) . "' $selected>" 
               . UtilRender::escapeHtml($option['text']) . "</option>";
    }
    
    $html .= "</select>";
    $html .= "</div>"; // cierre div col
    $html .= "</div>"; // cierre div row

    return $html;
}

}
?>