<?php

class util_html_table
{
    // create a th (column sortable )
    public static function th ($filters, $field, $label, $js='', $class='', $style='')
    {

        $label = util_languages::translate($label);

//        if (empty($style))  {$style = "'text-center col-sm-4'";}

        $icon_empty = '';
        $icon_asc = '▲';
        $icon_desc = '▼';
        $icon = '';
        $dir  = 'ASC';

        
        if ( !isset($filters['sort_column']) || $filters['sort_column']  != $field ) {
             $icon = $icon_empty; 
             $dir  = 'ASC';
        }
        else if ( $filters['sort_column'] == $field && ($filters['sort_direction'] === 'ASC' || $filters['sort_direction']=== '') ) { 
            $icon = $icon_asc; 
            $dir  = 'DESC';
        }
        else if ( $filters['sort_column'] == $field ) { 
            $icon = $icon_desc;
            $dir  = 'ASC';
        }

        $class_html = "";
        $style_html = "";
        $js_html = "";
        if (!empty($class)) {$class_html = " class={$class}"; }
        if (!empty($style)) {$style_html = " style={$style}" ; }
        if (!empty($js))    {$js_html    = "onclick = \"{$js}('$field', '$dir')\" ";}

        $html = "<th $class_html $style_html>";
//        $html .= "<button type='button' onclick=\"{$js}('$field', '$dir')\" class='btn btn-link'> $label $icon </button>";                
        $html .= "<button type='button' $js_html class='btn btn-link'> $label $icon </button>";                
        $html .= "</th>";
        return $html;
    }

    // create a td (celda)
    public static function td ($value, $class='', $style='')
    {
//        if (empty($class))  {$class = "'col-sm-4'";}

        $class_html = "";
        $style_html = "";
        if (!empty($class)) {$class_html = " class={$class}"; }
        if (!empty($style)) {$style_html = " style={$style}" ; }

        $html = "<td $class_html $style_html>" .UtilRender::escapeHtml($value)."</td>";
        return $html;
    }    

    public static function th2 ($value, $class='', $style='')
    {
//        if (empty($class))  {$class = "'col-sm-4'";}

        $class_html = "";
        $style_html = "";
        if (!empty($class)) {$class_html = " class={$class}"; }
        if (!empty($style)) {$style_html = " style={$style}" ; }

        $html = "<th $class_html $style_html>" .UtilRender::escapeHtml($value)."</th>";
        return $html;
    }    



    public static function create_boolean_td($value, $colClass = '', $style = 'text-align: center; vertical-align: middle;')
    {
        // Convertir el valor a booleano
        $isChecked = filter_var($value, FILTER_VALIDATE_BOOLEAN);
    
        $html = "<td class='$colClass align-middle' style='$style'>";
        $html .= "<div class='d-flex justify-content-center align-items-center'>";
    
        // Div personalizado - solo el cuadro sin checkmark
        $html .= "<div style='";
        $html .= "width: 20px; ";
        $html .= "height: 20px; ";
        $html .= "border: 2px solid #000000; ";
        $html .= "background-color: " . ($isChecked ? "#5c5c5cff" : "#ffffff") . "; ";
        $html .= "display: inline-block; ";
        $html .= "cursor: default;";
        $html .= "'>";
        $html .= "</div>"; // Cierra el div personalizado
    
        $html .= "</div>"; // Cierra el div flex
        $html .= "</td>";
    
        return $html;
    }

}
?>