
const debounceTimers = {};

// Filter buscador, no actualiza nada en la base de datos
$(document).ready(function () {

//    const debounceTimers = {};

    // Inicializa Flatpickr para todos los elementos con la clase 'date-filter'
    $(".filter-date").flatpickr({
        enableTime: false, // Desactivar la selección de tiempo si solo necesitas la fecha
        dateFormat: "Y-m-d", // Formato de fecha
        time_24hr: true, // Usar el formato de 24 horas
    });

    $(".filter_datetime_ini").flatpickr({
        enableTime: true,
        dateFormat: "Y-m-d H:i",
        time_24hr: true,
        defaultDate: new Date().fp_incr(0),
        maxDate: new Date().fp_incr(1),
        onChange: function (selectedDates, dateStr, instance) {
            endPicker.set('minDate', selectedDates[0]);
        }
    });

    $(".filter_datetime_fin").flatpickr({
        enableTime: true,
        dateFormat: "Y-m-d H:i",
        time_24hr: true,
        defaultDate: new Date().fp_incr(+1),
        minDate: new Date().fp_incr(0),
        onChange: function (selectedDates, dateStr, instance) {
            startPicker.set('maxDate', selectedDates[0]);
        }
    });



    // select2 initializa para las busquedas incrementales
    $('.searchable-select').select2({
    });

    // select2 on open
    $('.searchable-select').on('select2:open', function () {

        // focus al campo de busqueda al abrir el dropdown
        setTimeout(() => {
            let searchField = document.querySelector('.select2-container--open .select2-search__field');
            if (searchField) {
                searchField.focus();
            }
        }, 100); // Espera breve para que Select2 termine de abrir

        // Ajustar la altura máxima del dropdown dinámicamente
        let dropdown = $('.select2-container--open .select2-results__options');
        dropdown.css({
            'max-height': '300px', // Altura máxima visible
            'overflow-y': 'auto'   // Activar scroll si hay más opciones
        });
    });


}); //document ready


$(document).ready(function () {
    $('#clearFilters').click(function (){

        let action = $(this).attr('action');

        window.location.href = 'index.php?action=' + action;
    });
});

$(document).ready(function () {
    $('#exportExcel').click(function (){

        let idTable = $('#exportExcel').attr('idtable');

        $("#" + idTable).table2excel({
            name: "Tabla Exportada",
            filename: idTable, // Nombre del archivo
            fileext: ".xls" // Formato
        });
    });
});

$(document).ready(function () {
    $('#exportPDF').click(function () {
        const { jsPDF } = window.jspdf; // Accede a jsPDF
        const doc = new jsPDF();

        // Usa autoTable para exportar la tabla
        doc.autoTable({
            html: '#myTable', // ID de la tabla a exportar
            startY: 10, // Espaciado inicial
            theme: 'grid' // Tema de la tabla (opcional)
        });

        // Guarda el archivo PDF
        doc.save('tabla-exportada.pdf');
    });

});



$(document).ready(function () {

    $('#filter_spyder_alarms').on('input', function () {
        const fieldId = $(this).attr('id'); // Identifica el campo que disparó el evento.

        // Limpia el temporizador anterior para este campo.
        clearTimeout(debounceTimers[fieldId]);

        let value = $(this).val(); // Obtén el valor del campo.

        debounceTimers[fieldId] = setTimeout(() => { // Inicia un nuevo temporizador
            let params = new URLSearchParams(window.location.search);
            params.set('action', 'filter_spyder_alarms'); // Asegúrate de establecer el action correcto
            params.set('filter_searchValue', value);

            //        alert('asdf');

            $.ajax({
                url: 'index.php?' + params.toString(),
                type: 'GET',
                success: function (response) {
                    //                alert(response);
                    $('#spyder_alarms_table').html(response.table);
                    $('#spyder_alarms_pag').html(response.pagination);
                },
                error: function () {
                    console.error('Error al realizar la solicitud AJAX.');
                }
            });
        }, 300); // El retraso es de 300 ms. Puedes ajustarlo según sea necesario.
    });


}); 


function downloadJsonFile(data, filename = 'data.json') {
    // Crear un Blob con el contenido del JSON
    const blob = new Blob([JSON.stringify(data, null, 2)], { type: 'application/json' });

    // Crear una URL para el Blob
    const url = URL.createObjectURL(blob);

    // Crear un enlace y simular clic para descargar el archivo
    const a = document.createElement('a');
    a.href = url;
    a.download = filename; // Nombre del archivo
    document.body.appendChild(a);
    a.click();
    document.body.removeChild(a);

    // Liberar el objeto URL
    URL.revokeObjectURL(url);
}    


    // Cerrar el modal cuando el usuario haga clic en la 'X'
    $('.close').on('click', function() {
        $('#editModal').hide();

//            alert("close modal");
//        location.reload(); // hacemos un reload aqui, para que actualize la tabla principal
    });

    function recuperarSTS() {
        padre = $(window.parent.parent.document);
        var sts = [];
        $(padre).find("#contenedorSTS .selectorSTS").each(function (i, v) {
            var val = $(v).find("input[class=chk]:checked").val();
            if (val != undefined) {
                sts.push(val);
            }
        });
        console.log(sts);
        return sts;
    }
    
    function showSpinner() {
        document.getElementById('spinner-overlay').classList.remove('d-none');
    }

    function hideSpinner() {
        document.getElementById('spinner-overlay').classList.add('d-none');
    }