
// Actualizan el campo html y la base de datos
$(document).ready(function() {
    // Ajustar altura dinámicamente al escribir
    $(document).on('input', 'textarea.textarea-editable', function() {
            adjustHeight(this);
    });

    initializaEditables();
}); // document ready



// ojo!! tenemos que poner la inicializacion aqui pq al cargar la modal hay que inicializar otra vez ya que se carga despues del document ready
function initializaEditables()
{
    // eliminamos el posible mensaje de error, en los
    $('#error-message').remove();

    // Ajustar todos los textareas al cargar la página
    $('.textarea-editable').each(function() {
            adjustHeight(this);
    });

    $('.celdaTextAreaInTable').each(function() {
        adjustHeight(this);
    });

    
    $(".date-editable").flatpickr({
        enableTime: false, 
        dateFormat: "Y-m-d", 
        time_24hr: true, 

        onOpen: function(selectedDates, dateStr, instance) {
            let inputElement = instance.input; 
            $(inputElement).data("lastvalue", inputElement.value); // Guardar la fecha actual
        },

        onChange: function(selectedDates, dateStr, instance) {
            let inputElement = instance.input;  
            let id           = $(inputElement).data("id"); 
            let field        = $(inputElement).data("field"); 
            let action       = $(inputElement).data("action"); 

            let lastValue    = $(inputElement).data("lastvalue"); // Recuperar la fecha anterior
            if (!dateStr) {
                setTimeout(() => {
                    instance.setDate(lastValue, true); // Restaurar la fecha anterior
                }, 10);
                return;
            }

            $.ajax({
                url: 'index.php?action=' + action, 
                method: "POST",
                data: {
                    id: id,
                    field: field,
                    value: dateStr
                },
                success: function(response) {
                    console.log("Fecha actualizada con éxito:", response);
                },
                error: function(xhr, status, error) {
                    console.error("Error al actualizar la fecha:", error);
                }
            });
        }
    });

    $(".time-editableTOTAL").flatpickr({
        enableTime: true, 
        noCalendar: true, 
        dateFormat: "H:i",
        time_24hr: true,
        minuteIncrement: 5, // De 5 en 5 minutos
        allowInput: true, // Para permitir entrada manual, estoes pq nos da error sino lo ponemos con el time solo

        onOpen: function(selectedDates, dateStr, instance) {
            let inputElement = instance.input; 
            $(inputElement).data("lastvalue", inputElement.value); // Guardar la fecha actual
        },

        onClose: function(selectedDates, dateStr, instance) {
            let inputElement  = instance.input;     // elemento nativo javascript, no tiene .attr ni .css ... ej
            let $inputElement = $(inputElement);    // elemento nativo convertido a JQuery
            let id      = $inputElement.data("id");
            let field   = $inputElement.data("field");
            let action  = $inputElement.data("action");
            let idform  = $inputElement.data("idform");

            let lastValue    = $inputElement.data("lastvalue"); // Recuperar la fecha anterior

            if (!dateStr || !isValidTime(dateStr)) {
                disableCloseButton(); // evita que podamos cerrar la modal
    
                $inputElement.css({"color": "red" }); 
                $inputElement.attr('title', 'Error: Invalid time');
                setTimeout(() => {
                    $inputElement.blur(); // quitamos el foco primero o no funciona
                    $inputElement.focus();
//                     instance.setDate(lastValue, true); 
                    }, 10); 

                $inputElement.tooltip({
                    show: { effect: "slideDown", duration: 200 },
                    hide: { effect: "slideUp", duration: 200 }
                });
                return;            
            }
            else {
                enableCloseButton();
                $inputElement.css({"color": "black"}); // Restaurar estilos
                $inputElement.removeAttr('title'); // Eliminar el mensaje de error
                $inputElement.tooltip('dispose');
            }


            $.ajax({
                url: 'index.php?action=' + action, 
                method: "POST",
                data: {
                    id: id,
                    field: field,
                    value: dateStr
                },
                success: function(response) {
                    console.log("Hora actualizada con éxito 108:", response);
                    updateTotals(idform);
                },
                error: function(xhr, status, error) {
                    console.error("Error updating hour:", error);
                }
            });
        }
    });

    //////////////////////////////////////////////////////////////////////////////////////////////////////////////

    $(".time-editable").flatpickr({
        enableTime: true, 
        noCalendar: true, 
        dateFormat: "H:i",
        time_24hr: true,
        minuteIncrement: 5, 
        allowInput: true, 

        onOpen: function(selectedDates, dateStr, instance) {
            let inputElement = instance.input; 
            $(inputElement).data("lastvalue", inputElement.value); // Guardar la fecha actual
        },

        onClose: function(selectedDates, dateStr, instance) {
            let inputElement  = instance.input;     // elemento nativo javascript, no tiene .attr ni .css ... ej
            let $inputElement = $(inputElement);    // elemento nativo convertido a JQuery
            let id      = $inputElement.data("id");
            let field   = $inputElement.data("field");
            let action  = $inputElement.data("action");

            let lastValue    = $inputElement.data("lastvalue"); // Recuperar la fecha anterior


            if (!dateStr || !isValidTime(dateStr)) {
                disableCloseButton(); // evita que podamos cerrar la modal
    
                $inputElement.css({"color": "red" }); 
                $inputElement.attr('title', 'Error: Invalid time');
                setTimeout(() => {
                    $inputElement.blur(); // quitamos el foco primero o no funciona
                    $inputElement.focus();
//                     instance.setDate(lastValue, true); 
                    }, 10); 

                $inputElement.tooltip({
                    show: { effect: "slideDown", duration: 200 },
                    hide: { effect: "slideUp", duration: 200 }
                });
                return;            
            }
            else {
                enableCloseButton();
                $inputElement.css({"color": "black"}); // Restaurar estilos
                $inputElement.removeAttr('title'); // Eliminar el mensaje de error
                $inputElement.tooltip('dispose');
            }            


            $.ajax({
                url: 'index.php?action=' + action, // URL para el script de actualización en tu servidor
                method: "POST",
                data: {
                    id: id,
                    field: field,
                    value: dateStr
                },
                success: function(response) {
                    console.log("Hora actualizada con éxito:", response);
                },
                error: function(xhr, status, error) {
                    console.error("Error al actualizar la hora:", error);
                }
            });
        }
    });



    
//    $(".time-editable24_from").each(function() {
        /*
        let inputElement = $(this);

        inputElement.on("change", function() {
            let input_from = inputElement;
            let input_to   = $(this).closest("tr").find("input[data-field*='to']"); 

            if (input_from.val() === "00:00" && input_to.val() === "24:00") {
                input_to.val("00:00"); 
            } 

            if (input_from.val() != "00:00" && input_to.val() === "00:00") {
                input_to.val("24:00"); 
            } 
*/
//        });
//    });



    $(".time-editable24_to").each(function() {
        let input_from      = $(this).closest("tr").find("input[data-field*='from']");        
        let input_fromValue = input_from.val();
        let input_to        = $(this);
        let input_toValue   = input_to.val().slice(0,5); // Tomar solo "HH:MM" y descartar los segundos

        let flatpickrValue =  input_toValue;
        
        let inputElement = $(this);
        
        // Mostrar "24:00" en el campo si venía "00:00"
        if (input_toValue === "24:00") {
            input_to.val("24:00");
        }        
        
    
        inputElement.flatpickr({
            enableTime: true, 
            noCalendar: true, 
            dateFormat: "H:i",
            time_24hr: true,
            minuteIncrement: 5, // De 5 en 5 minutos
            allowInput: true, // Para permitir entrada manual        

            defaultDate: flatpickrValue, // Usar "00:00" si venía "24:00"

            onOpen: function(selectedDates, dateStr, instance) {
                let inputElement = instance.input; 
                $(inputElement).data("lastvalue", inputElement.value); // guarda el time  actual
            },
    
            onClose: function(selectedDates, dateStr, instance) {
                let inputElement  = instance.input;     // elemento nativo javascript, no tiene .attr ni .css ... ej
                let $inputElement = $(inputElement);    // elemento nativo convertido a JQuery
                let id      = $inputElement.data("id");
                let field   = $inputElement.data("field");
                let action  = $inputElement.data("action");
                let idform  = $inputElement.data("idform");
                let lastValue    = $inputElement.data("lastvalue"); 

                if (dateStr === "00:00") {
                    instance.input.value = "24:00"; // Mostrar "24:00"
                }


                if (!dateStr || !isValidTime(dateStr)) {
                    disableCloseButton(); // evita que podamos cerrar la modal
        
                    $inputElement.css({"color": "red" }); 
                    $inputElement.attr('title', 'Error: Invalid time');
                    setTimeout(() => {
                        $inputElement.blur(); // quitamos el foco primero o no funciona
                        $inputElement.focus();
    //                     instance.setDate(lastValue, true); 
                        }, 10); 
    
                    $inputElement.tooltip({
                        show: { effect: "slideDown", duration: 200 },
                        hide: { effect: "slideUp", duration: 200 }
                    });
                    return;            
                }
                else {
                    enableCloseButton();
                    $inputElement.css({"color": "black"}); // Restaurar estilos
                    $inputElement.removeAttr('title'); // Eliminar el mensaje de error
                    $inputElement.tooltip('dispose');
                }

                $.ajax({
                    url: 'index.php?action=' + action, // URL para el script de actualización en tu servidor
                    method: "POST",
                    data: {
                        id: id,
                        field: field,
                        value: dateStr
                    },
                    success: function(response) {
                        console.log("Hora actualizada con éxit line 213:", response);

                        if (idform != null) 
                        {
                            updateTotals(idform);
                        }
                    },
                    error: function(xhr, status, error) {
                        console.error("Error al actualizar la hora:", error);
                    }
                });
            }
            
//            onClose: function(selectedDates, dateStr, instance) {

//                if (dateStr === "00:00" ) {
//                  instance.input.value = "24:00"; // Mostrar "24:00"
//                }
                /*
                if (dateStr === "00:00" && input_fromValue != "00:00") {
                    instance.input.value = "24:00"; // Mostrar "24:00"
                }

                if (dateStr === "24:00" && input_fromValue === "00:00") {
                    instance.input.value = "00:00"; // Mostrar "24:00"
                }
                */
//            }            
        });

        
        // Esperar a que Flatpickr termine su inicialización y luego forzar "24:00" si aplica
        setTimeout(() => {
            console.log("input_fromValue: " + input_fromValue);
            console.log("input_toValue: " +  input_toValue);

            if (input_toValue === "24:00" )  { inputElement.val("24:00"); }

            /*
            if (input_toValue === "00:00" && input_fromValue != "00:00") {
                input_to.val("24:00");
            }

            if (input_toValue === "24:00" && input_fromValue == "00:00")  {
                inputElement.val("00:00");
            }
           */
               
        }, 10);   
             
    });
    




/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////




    // <td> no es editable por defecto, por lo que onchange no funcionara.
    // tenemos que usar onblur,  en el td añadimos contenteditable='true', y usamos text() en vez de val()
    // OJO este es para campos de tipo int, para tipo string hay otro
    $('.td_editable').on('blur', function() {
        let inputElement = $(this);        
        let fieldValue    = inputElement.text().trim();
        let id            = inputElement.data('id');
        let fieldKey      = inputElement.data('field');
        let action        = inputElement.data('action');
        let originalvalue = inputElement.data('originalvalue'); // cogemos el valor originial antes de modificarlo

        // Validar si es un número entero positivo
        if (!/^\d+$/.test(fieldValue))
        {
            disableCloseButton(); // evita que podamos cerrar la modal

            inputElement.css({"color": "red" }); 
            inputElement.attr('title', 'Error: Invalid Value, must be a integer number.');
            setTimeout(() => { inputElement.focus(); }, 10); // Mantener el foco en el elemento

            inputElement.tooltip({
                show: { effect: "slideDown", duration: 200 },
                hide: { effect: "slideUp", duration: 200 }
            });
            return;            
        } 
        else {
            enableCloseButton();
            inputElement.css({"color": "black"}); // Restaurar estilos
            inputElement.removeAttr('title'); // Eliminar el mensaje de error
            inputElement.tooltip('dispose');
        }


        // si es un valor valido, lo guardamoe en el mismo input
        inputElement.data('originalvalue', fieldValue);

        $.ajax({
            url: 'index.php?action=' + action, // URL para el script de actualización en tu servidor
            method: "POST",
                data: {
                    id: id,
                    field: fieldKey,
                    value: fieldValue
                },
                success: function(response) {
                    if (response.status === "error") {
                        showCustomAlert(response.message, null);
                    }
                },
                error: function(xhr, status, error) {
                    console.error("update error: ", error);
                }
        });
    });


    // similar a los campos td_editables pero que tambien son totales
    $('.td_editableTOTAL').on('blur', function() {
        let inputElement = $(this);        
        let fieldValue    = inputElement.text().trim();
        let id            = inputElement.data('id');
        let fieldKey      = inputElement.data('field');
        let action        = inputElement.data('action');
        let idform        = inputElement.data('idform');
        let originalvalue = inputElement.data('originalvalue'); // cogemos el valor originial antes de modificarlo


        // Validar si es un número entero positivo
        if (!/^\d+$/.test(fieldValue))
            {
                disableCloseButton(); // evita que podamos cerrar la modal

                inputElement.css({"color": "red" }); 
                inputElement.attr('title', 'Error: Invalid Value, must be a integer number.');
                setTimeout(() => { inputElement.focus(); }, 10); // Mantener el foco en el elemento
    
                inputElement.tooltip({
                    show: { effect: "slideDown", duration: 200 },
                    hide: { effect: "slideUp", duration: 200 }
                });

                return;            
            } 
            else {
                enableCloseButton();                                
                inputElement.css({"color": "black"}); // Restaurar estilos
                inputElement.removeAttr('title'); // Eliminar el mensaje de error
//                inputElement.tooltip("close"); // Cerrar el tooltip si es válido      
                inputElement.tooltip('dispose');
            }

            // si es un valor valido, lo guardamoe en el mismo input
            inputElement.data('originalvalue', fieldValue);

            console.log("ajax");

        $.ajax({
            url: 'index.php?action=' + action, // URL para el script de actualización en tu servidor
            method: "POST",
            data: {
                    id: id,
                    field: fieldKey,
                    value: fieldValue
                  },
            success: function(response) {
                console.log("update success: ", response);
                updateTotals(idform)
            },
            error: function(xhr, status, error) {
                console.error("update error: ", error);
            }
        });
    });



    $('.td_editableString').on('blur', function() {
        //        var fieldValue   = $(this).val();
        var fieldValue   = $(this).text();
        var id           = $(this).data('id');
        var fieldKey     = $(this).data('field');
        var action       = $(this).data('action');
        //        alert("td_editable");

        $.ajax({
            url: 'index.php?action=' + action, // URL para el script de actualización en tu servidor
            method: "POST",
                data: {
                    id: id,
                    field: fieldKey,
                    value: fieldValue
                },
                success: function(response) {
//                    console.log("update success: ", response);
                    if (response.status === "error") {
                        showCustomAlert(response.error, null);
                    }
                },
                error: function(xhr, status, error) {
                    console.error("update error: ", error);
                }
        });
    });


    $('.boolean-editable').on('change', function() {

        var id = $(this).data('id');
        var fieldKey = $(this).data('field');
        var fieldValue = $(this).is(':checked') ? 1 : 0;
        var action = $(this).data('action');
        //        alert("boolean editable");

        //  alert("id: " + id + " fieldKey: " + fieldKey + " fieldValue: " + fieldValue + " action:" + action );
        $.ajax({
            url: 'index.php?action=' + action,
            method: 'POST',
            data: {
                id: id,
                field: fieldKey,
                value: fieldValue
                },
                success: function(response) {
                    console.log('Update success: ', response);
                },
                error: function(xhr, status, error) {
                    console.error('Update error: ', error);
                }
        });
    });

    $('.dropdown-editable').on('change', function() {
        var fieldValue   = $(this).val();
        var id           = $(this).data('id');
        var fieldKey     = $(this).data('field');
        var action       = $(this).data('action');

        $.ajax({
            url: 'index.php?action=' + action, // URL para el script de actualización en tu servidor
            method: "POST",
            data: {
                id: id,
                field: fieldKey,
                value: fieldValue
            },
            success: function(response) {
                console.log("update success: ", response);
            },
            error: function(xhr, status, error) {
                console.error("update error: ", error);
            }
        });
    });

    $('.textarea-editable').on('change', function() {
        var fieldValue    = $(this).val();
        var id            = $(this).data('id');
        var fieldKey      = $(this).data('field');
        var action        = $(this).data('action');

        $.ajax({
            url: 'index.php?action=' + action, 
            method: "POST",
            data: {
                id: id,
                field: fieldKey,
                value: fieldValue
            },
            success: function(response) {
                console.log("update success: ", response);
            },
            error: function(xhr, status, error) {
                console.error("update error: ", error);
            }
        });
    });
            
}

// ajustar la altura de textArea
function adjustHeight(textarea)
{
//    alert("adjustheight" + textarea);
    textarea.style.height = 'auto'; // Resetea la altura para calcular correctamente el scrollHeight
    textarea.style.height = textarea.scrollHeight + 'px'; // Ajusta la altura al contenido
}



function showCustomAlert(message, callback) {
    // Eliminar cualquier modal previo
    $(".custom-alert").remove();

    // Crear el modal
    let alertBox = $(`
        <div class="custom-alert-overlay" style="position: fixed; top: 0; left: 0; width: 100%; height: 100%; z-index: 9999; background: rgba(0,0,0,0.5);">
            <div class="custom-alert">
                <p>${message}</p>
                <button id="closeAlert">Aceptar</button>
            </div>
        </div>
    `);

    // Agregarlo al body
    $("body").append(alertBox);

    // Cerrar el modal y ejecutar el callback
    $("#closeAlert").on("click", function() {
        $(".custom-alert-overlay").fadeOut(200, function() {
            $(this).remove();
            if (callback) callback(); // Llamar al callback si existe
        });
    });
}


// Variable para controlar si la tecla Escape está bloqueada
let escapeBlocked = false;

// Función para deshabilitar el botón de cierre y mostrar el mensaje de error
function disableCloseButton() {
//    alert("disableCloseButton");

    // Deshabilitar el botón de cierre
    $('#closeButton').prop('disabled', true);
    $('#closeButton').css({
        'background-color': '#ccc',  // Cambiar color para mostrar que está deshabilitado
        'cursor': 'not-allowed'      // Cambiar cursor
    });

//    showCustomAlert("Invalid form");
    // Mostrar el mensaje de error debajo del botón de cierre
    if ($('#error-message').length === 0) {
        $('#closeButton').after('<span id="error-message" style="color: red; font-size: 20px; margin-top: 10px; display: block; text-align: center;">Error: Debe ser un número entero positivo</span>');
    }    

    /*
    // Bloquear la tecla Escape si no está bloqueada
    if (!escapeBlocked) {
        $(document).on('keydown', function(e) {
            if (e.key === "Escape" || e.keyCode === 27) {
                e.preventDefault();  // Evita que la tecla Escape cierre la modal
                alert("No puedes cerrar la ventana hasta corregir el error.");  // Mostrar alerta cuando se presiona Escape
            }
        });

        // Marcar que la tecla Escape está bloqueada
        escapeBlocked = true;
    }    
        */
}

// Función para habilitar el botón de cierre y quitar el mensaje de error
function enableCloseButton() {
//    alert("enableCloseButton");

    // Habilitar el botón de cierre
    $('#closeButton').prop('disabled', false);
    $('#closeButton').css({
        'background-color': '',      // Restaurar color original
        'cursor': ''                 // Restaurar cursor original
    });

    // Eliminar el mensaje de error
    $('#error-message').remove();

    // Habilitar la tecla Escape de nuevo
//    $(document).off('keydown');  // Desactiva el bloqueo de la tecla Escape    

    /*
    // Desmarcar el flag para permitir que la tecla Escape funcione de nuevo
    escapeBlocked = false;    
    */
}


// valida time. entre 00:00 y 24:00
function isValidTime(timeStr) {
    // Validar formato HH:mm
    let timePattern = /^([01]?\d|2[0-3]):([0-5]?\d)$/; // Acepta 00:00 a 23:59
    let midnightPattern = /^24:00$/; // Permitir solo exactamente 24:00

    return timePattern.test(timeStr) || midnightPattern.test(timeStr);
}