<?php
    require_once __DIR__ . '/auth/auth.php';
    require_once __DIR__ . '/setup.php';



    function get_html_head($page) {

        $num = rand();

        $extraIncludes = 
        // 1. jQuery primero
        '<script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>' .
    
        // 2. Bootstrap CSS
        '<link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">' .
    
        // 3. Otros CSS de plugins
        '<link rel="stylesheet" href="//cdnjs.cloudflare.com/ajax/libs/timepicker/1.3.5/jquery.timepicker.min.css">' .
        '<link rel="stylesheet" href="./plugins/flatpickr/flatpickr.css" />' .
        '<link rel="stylesheet" href="./plugins/select2/select2.css" />' .
    
        // 4. CSS propios
        '<link rel="stylesheet" href="./css/mont_paginacion.css?ts=' . $num . '" />' .
        '<link rel="stylesheet" href="./css/mont_filters.css?ts=' . $num . '" />' .
        '<link rel="stylesheet" href="./css/mont.css?ts=' . $num . '" />' .
        '<link rel="stylesheet" href="./css/custom.css?ts=' . $num . '" />' .
        '<link rel="stylesheet" href="./css/modal.css?ts=' . $num . '" />' .
    
        // 5. Plugins JS que dependen de jQuery
        '<script src="//cdnjs.cloudflare.com/ajax/libs/timepicker/1.3.5/jquery.timepicker.min.js"></script>' .
        '<script src="./plugins/flatpickr/flatpickr"></script>' .
        '<script src="./plugins/select2/select2.js"></script>' .
        '<script src="./plugins/table2excel/jquery.table2excel.min.js"></script>' .
        '<script src="./plugins/jspdf/jspdf.umd.min.js"></script>' .
        '<script src="./plugins/jspdf/jspdf.plugin.autotable.min.js"></script>' .
    
        // 6. Bootstrap JS después de jQuery
        '<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.bundle.min.js"></script>' ;
    

        if ($page == 'instalacion') { $extraIncludes .= '<script src="/modules/instalacion/instalacion.js?ts=' . $num . '"></script>'; }
        if ($page == 'equipos')     { $extraIncludes .= '<script src="/modules/equipos/equipos.js?ts=' . $num . '"></script>'; }
        if ($page == 'usuarios')    { $extraIncludes .= '<script src="/modules/usuarios/usuarios.js?ts=' . $num . '"></script>'; }
        if ($page == 'languages')   { $extraIncludes .= '<script src="/modules/languages/languages.js?ts=' . $num . '"></script>'; }
        if ($page == 'instalador')  { $extraIncludes .= '<script src="/modules/instalador/instalador.js?ts=' . $num . '"></script>'; }

        return $extraIncludes;
    }





    function render_mainframe( $action, $extraIncludes, $content)
    {
// Si es HTML, mostramos los scripts, CSS y modal
?>

<!DOCTYPE html>
<html lang="es">
<head>
 
<meta charset="UTF-8">
<title>Contenido <?php echo $page; ?></title>
<?
    if ($action && strpos($action, 'edit_') === false) {
        echo $extraIncludes;
    }
?>
</head>
<body class="bg-light p-3">

<!-- Contenido principal -->
<div id="mainContent">
    <?php echo $content; ?>
</div>

<!-- Modal -->
<div id="editModal" class="modal" data-backdrop="false">
    <div id="modal-content" class="modal-content" style="width: 50%;">
        <div>
<!--            <button id="closeButton" type="button" onclick="hideModal()" class="close btn btn-primary">Save & Return</button> -->
        </div>
        <div class="modal-header" 
                        style='background: linear-gradient(to right, #a1cbf7ff, #ffffff);
                        display: flex; 
                        align-items: center; 
                        justify-content: flex-start; 
                        min-height: 70px; 
                        padding: 20px 30px;'>"; 

            <h5 class="modal-title" id="modal-title">Edit</h5>
        </div>
        <div id="modalFormContent"></div>
    </div>
</div>

<script>
function openEditModal(url) {
    // Carga contenido en el modal **sin recargar scripts**
    $('#modalFormContent').load(url, function() {
        $('#editModal').modal('show');
    });
}
</script>

</body>
</html>
<?
    } 