// Estado global de equipos
const equiposState = {
    search: '',
    pag_page: 1,
    pag_limit: 10,
    sort_column: '',
    sort_direction: 'ASC',
    filter_instalacion_tipo : -1,
    filter_instalador : -1,
    filter_equipos_nocomm: 0
};

// Inizializa el estado desde la URL
function initStateFromUrl() {
    const params = new URLSearchParams(window.location.search);

    equiposState.search        = params.get('search')   || '';
    equiposState.pag_page      = parseInt(params.get('pag_page')) || 1;
    equiposState.pag_limit     = parseInt(params.get('pag_limit')) || 10;
    equiposState.sortColumn    = params.get('sort_column')   || 'nombre_inst';
    equiposState.sortDirection = params.get('sort_direction') || 'ASC';
    equiposState.filter_instalacion_tipo = params.get('filter_instalacion_tipo') || -1;
    equiposState.filter_instalador       = params.get('filter_instalador') || -1;
    equiposState.filter_equipos_nocomm   = params.get('filter_equipos_nocomm') || 0;

    // Actualiza inputs en la UI para reflejar el estado
    $('#search').val(equiposState.search);
    $('#pag_limit').val(equiposState.pag_limit);
    $('#filter_instalacion_tipo').val(equiposState.filter_instalacion_tipo);
    $('#filter_instalador').val(equiposState.filter_instalador);
    $('#filter_equipos_nocomm').val(equiposState.filter_equipos_nocomm);
}


// Actualiza URL desde el estado
function updateUrlFromState() {
    const params = new URLSearchParams({
        search:         equiposState.search,
        pag_page:       equiposState.pag_page,
        pag_limit:      equiposState.pag_limit,
        sort_column:    equiposState.sort_column,
        sort_direction: equiposState.sort_direction,
        filter_instalacion_tipo: equiposState.filter_instalacion_tipo,
        filter_instalador: equiposState.filter_instalador,
        filter_equipos_nocomm: equiposState.filter_equipos_nocomm
    });
    history.pushState({}, '', `${window.location.pathname}?${params.toString()}`);
}


// Cargar datos 
async function equipos_loadData() {
    updateUrlFromState(); // sincroniza URL (opcional para la URL visible)

    const postData = new URLSearchParams({
        page: 'equipos',
        action: 'equipos_filter',
        search:                   equiposState.search,
        pag_page:                 equiposState.pag_page,
        pag_limit:                equiposState.pag_limit,
        sort_column:              equiposState.sort_column,
        sort_direction:           equiposState.sort_direction,
        filter_instalacion_tipo:  equiposState.filter_instalacion_tipo,
        filter_instalador:        equiposState.filter_instalador,
        filter_equipos_nocomm:    equiposState.filter_equipos_nocomm
    });

//    alert(postData);
    try {
        const response = await fetch('mainframe.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded'
            },
            body: postData.toString()
        });

        if (!response.ok) throw new Error(`HTTP error! status: ${response.status}`);

        const data = await response.json();

        $('#equipos_table').html(data.table);
        $('#equipos_pag').html(data.pagination);

        // Ajustar paginación si totalRecords viene en la respuesta
        if (data.totalRecords) {
            const totalPages = Math.max(1, Math.ceil(data.totalRecords / equiposState.pag_limit));
            if (equiposState.pag_page > totalPages) {
                equiposState.pag_page = totalPages;
                equipos_loadData();
            }
        }
    } catch (err) {
        console.error('Error al cargar datos:', err);
    }
}


function equipos_sort(field, dir) {
    equiposState.sort_column = field;
    equiposState.sort_direction = dir;
    equipos_loadData();
}

// Función genérica para actualizar filtros
function equipos_updateFilterField(fieldId, fieldValue) {
//    alert(fieldValue );
    equiposState[fieldId] = fieldValue;
    equiposState.pag_page = 1; // reinicia página cuando cambia un filtro
    equipos_loadData();       
}


// =============================
// Document Ready
// =============================
$(document).ready(function () {
        // Asegurarse de que debounceTimers exista, si no, inicializarlo
    if (typeof debounceTimers === 'undefined') {
        debounceTimers = {}; // Inicializar si no existe
    }

    initStateFromUrl();
    equipos_loadData();

    /*
    // evento para los filtros
    $('.filter_equipos').on('input', function () {
        const fieldId    = $(this).attr('id'); // Identifica el campo que disparó el evento.
        const fieldValue = $(this).val();
        clearTimeout(debounceTimers[fieldId]); // Limpia el temporizador anterior para este campo.

        debounceTimers[fieldId] = setTimeout(() => { 
            equipos_updateFilterField(fieldId, fieldValue);
        }, 300); // El retraso es de 300 ms. Puedes ajustarlo según sea necesario.
    });
    */

    // evento para los filtros
    $('.filter_equipos').on('input', function () {
        const fieldId    = $(this).attr('id'); // Identifica el campo que disparó el evento.
        let fieldValue;

        if ($(this).attr('type') === 'checkbox') {
            fieldValue = $(this).prop('checked') ? 1 : 0;
        } else {
            fieldValue = $(this).val();
        }

//        alert(fieldId + " " + fieldValue);

        clearTimeout(debounceTimers[fieldId]); // Limpia el temporizador anterior para este campo.
        debounceTimers[fieldId] = setTimeout(() => { 
            equipos_updateFilterField(fieldId, fieldValue);
        }, 300); // El retraso es de 300 ms. Puedes ajustarlo según sea necesario.
    });


    // evento para paginación
    $(document).on('click', '.pagination-btn', function() {
        const page = parseInt($(this).data('page'));
        if (!isNaN(page)) {
            equiposState.pag_page = page;
            equipos_loadData(); // recarga vía AJAX con la nueva página
        }
    });    
});


async function equipos_insertButton()
{
    try
    {
        const page   = 'equipos';
        const action = 'equipos_insert';

        const response = await fetch(`mainframe.php?page=${page}&action=${action}`, { method: 'GET' });
        if (!response.ok) { 
            throw new Error(`HTTP error! status: ${response.status}`); 
        }

        const data = await response.json();
        if (data.status === 'success')
        {
            equipos_edit( data.lastId, () => {
                equipos_loadData();                
            } );
        }
        else 
        { console.error(data.status); }           
    } 
    catch (error) {
        console.error('Error:', error);
    }
}


function equipos_editButton(p)
{
    equipos_edit (p.id, () => {
       equipos_loadData();            
    });
}

function equipos_edit(id, onClose) {
    const page   = 'equipos';
    const action = 'equipos_edit';

    $.ajax({
        url: 'mainframe.php', // Cambia esto con la URL que necesites
        type: 'GET',
        data: { page: page, action: action, Id: id },
        success: function(response) {
            $('#modalFormContent').html(response); // Cargar el formulario dentro del modal
            $('#editModal').modal('show'); 

            $('#editModal').off('hidden.bs.modal').on('hidden.bs.modal', () => {
                console.log('Modal cerrado');
                if (typeof onClose === 'function') {
                    console.log('Modal cerrado callback');
                    onClose();
                }
              });            
        },
        error: function(xhr, status, error) {
            console.error('Error al obtener el formulario:', status, error);
        }
    });
}


async function equipos_update(id)
{
    const params = new URLSearchParams();

    params.append("Id", id);
    params.append("ns", document.getElementById("ns").value);
/*
    params.append("IP_Equipo", document.getElementById("IP_Equipo").value);
    params.append("IP", document.getElementById("IP").value);
    params.append("lastip", document.getElementById("lastip").value);
    params.append("Puerto_Equipo", document.getElementById("Puerto_Equipo").value);
    params.append("Columna 3", document.getElementById("Columna 3").value);
    params.append("UltimaRecepcion", document.getElementById("UltimaRecepcion").value);
    params.append("UltimoRegistro", document.getElementById("UltimoRegistro").value);
    params.append("MinMaxSinPq", document.getElementById("MinMaxSinPq").value);
    params.append("BytesTx", document.getElementById("BytesTx").value);
    params.append("BytesRx", document.getElementById("BytesRx").value);
    params.append("NCambiosIP", document.getElementById("NCambiosIP").value);
    params.append("UltimaPeticion", document.getElementById("UltimaPeticion").value);
    params.append("Cuarentena", document.getElementById("Cuarentena").value);
    */
    params.append("PIN", document.getElementById("PIN").value);
    params.append("Descriptor", document.getElementById("Descriptor").value);
//    params.append("id_motorcom", document.getElementById("id_motorcom").value);
    params.append("numero_corto", document.getElementById("numero_corto").value);
    params.append("numero_largo", document.getElementById("numero_largo").value);
    params.append("diferenciahoraria", document.getElementById("diferenciahoraria").value);
    params.append("estudiarcomm", document.getElementById("estudiarcomm").value);
    params.append("estudiaralim", document.getElementById("estudiaralim").value);
    params.append("asp", document.getElementById("asp").value);
    params.append("instalador", document.getElementById("instalador").value);
    params.append("tipoinstalacion", document.getElementById("tipoinstalacion").value);
    params.append("instalacion", document.getElementById("instalacion").value);
    params.append("asp", document.getElementById("asp").value);
//    alert(params);

    try
    {
        page   = 'equipos',
        action = 'equipos_update'

        const response = await fetch(`mainframe.php?page=${page}&action=${action}`, {
            method: 'POST',
            headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
            body: params.toString()            
        });

        if (!response.ok) { throw new Error(`HTTP error! status: ${response.status}`); }

        const data = await response.json();
        if (data.status === 'success')
        {
            hideModal();
        }
        else 
        {
            console.error(data.message);            
        }
    }
    catch (error) {
        console.error('Error:', error);
    }
}

async function equipos_delete(p)
{
    try
    {
        const confirmDelete = confirm("Are you sure to delete this equipos?" + p.id);
        if (!confirmDelete) {
            return; 
        }

        const page   = 'equipos';
        const action = 'equipos_delete';

        const response = await fetch(`mainframe.php?page=${page}&action=${action}&Id=${p.id}`);
        if (!response.ok) { 
            throw new Error(`HTTP error! status: ${response.status}`); 
        }

        const data = await response.json();
        if (data.status === 'success')
        {
             equipos_loadData();                
        }
        else {
             console.error('Error:', error); 
            }
    }
    catch (error) {
        console.error('Error:', error);
    }
}

function hideModal() {
//    alert("hideModal1")
    $('#editModal').modal('hide'); // Usar el método de Bootstrap
    equipos_loadData();
}
