<?php

class equipos_controller
{
    private $equipos_model;
    private $equipos_view;
    private $instalacion_model;
    private $usuarios_model;

    private $usuario;   // datos de usuario menos la pass
    private $level;     // level de servicio
    private $asp;       // asp
    private $language;  // language

    public function __construct($container) 
    {
        $this->equipos_model      = $container->get('equipos_model');
        $this->equipos_view       = $container->get('equipos_view');
        $this->instalacion_model  = $container->get('instalacion_model');
        $this->usuarios_model     = $container->get('usuarios_model');
    }

    public function checkAction($usuario, $params) 
    {
        $this->usuario = $usuario;
        $this->asp     = $usuario['asp'];
        $this->language = $usuario['language'];
        $this->level    = $this->usuarios_model->get_level_servicio( $usuario['id'], "equipos" );

        $filters = [];
        $filters['search']                   = (isset($params['search']))   ? UtilParams::sanitizeString($params['search']) : '';
        $filters['filter_instalacion_tipo']  = (isset($params['filter_instalacion_tipo']))   ? UtilParams::sanitizeString($params['filter_instalacion_tipo']) : -1;
        $filters['filter_instalador']        = (isset($params['filter_instalador']))         ? UtilParams::sanitizeString($params['filter_instalador']) : -1;
        $filters['filter_equipos_nocomm']    = (isset($params['filter_equipos_nocomm']))     ? UtilParams::sanitizeString($params['filter_equipos_nocomm']) : -1;
        $filters['filter_asp']               = $usuario['asp'];
        $filters['filter_instalaciones']     = $this->instalacion_model->get_instalaciones_array($usuario['id']);
        $filters = util_html_filter::getParams_pag ($params,$filters);
        $filters = util_html_filter::getParams_sort($params, $filters);        


        $action     = isset($params['action'])   ? UtilParams::sanitizeString($params['action']) : 'equipos_showAll';
        $equipo_id  = isset($params['Id'])       ? UtilParams::sanitizeString( $params['Id'] ) : ''; // equipo id

        // html        
        if      ( $action === 'equipos_showAll' ) { return $this->showAllAction($filters); }        
        else if ( $action === 'equipos_edit' )    { $this->editAction($equipo_id); }        
        // json
        else if ( $action === 'equipos_filter' )  { $this->filterAction($filters); }
        else if ( $action === 'equipos_insert' )  { $this->insertAction(); }        
        else if ( $action === 'equipos_update' )  { $this->updateAction($equipo_id, $params); }        
        else if ( $action === 'equipos_delete' )  { $this->deleteAction($equipo_id); }        
    }

    ///   ACCIONES HTML    ///
    private function showAllAction($filters)
    {
        $count = $this->equipos_model->count($filters, false);
        if ($filters['filter_equipos_nocomm'] === '1') {
            $data  = $this->equipos_model->select_equipos_nocomm($filters);
        }
        else {
            $data  = $this->equipos_model->selectAll($filters);
        }

        
        $html_filter  = $this->equipos_view->showFilter    ($filters, $this->level, $this->asp );
        $html_table   = $this->equipos_view->showAll       ($filters, $this->level, $this->asp, $data);
        $html_pag     = util_html_filter::showPaginacion($filters, $count, 'equipos_showAll');
        $html_pag     = "";

        $content = "";
        $content .= UtilRender::showHead( "Equipos" );
        $content .= "<div>";
        $content .= "<div id='equipos_filter'>".$html_filter."</div>";
        $content .= "<hr>";
        $content .= "<div id='equipos_table'>".$html_table."</div>";
        $content .= "<hr>";
        $content .= "<div id='equipos_pag'>".$html_pag."</div>";
        $content .= "</div>";
        return $content;
    }

    private function editAction($equipo_id)
    {
        $data = $this->equipos_model->select($equipo_id)[0];
        echo $this->equipos_view->showId($data, $this->level,$this->asp, $this->usuario);
        exit;
    }


    ///   ACCIONES AJAX    ///
    // devuelve json, con tabla + paginacion
    public function filterAction($filters)
    {
        $count   = $this->equipos_model->count($filters, false);
        if ($filters['filter_equipos_nocomm'] === '1' ) {
            $data  = $this->equipos_model->select_equipos_nocomm($filters);
        }
        else {
            $data  = $this->equipos_model->selectAll($filters);
        }


        $html_table   = $this->equipos_view->showAll       ($filters, $this->level, $this->asp, $data);
        $html_pag     = util_html_filter::showPaginacion($filters, $count, 'equipos_showAll');

        $response = [
            'table'      => $html_table,
            'pagination' => $html_pag,
            'totalRecords' => $count
        ];

        header('Content-Type: application/json');
        echo json_encode($response);
        exit;
    }

    private function insertAction()
    {
        try
        {
            $lastId = $this->equipos_model->lastId();
            $newId = $lastId + 1; // Sumar 1 al último ID   , esto es para que no haya duplicados en el nombre        

            $success = $this->equipos_model->insert( "new equipos". $newId, $newId) ;
            if ($success) 
            {
                $lastId = $newId;
                Util:: jsonResponse('success', SUCCESS_INSERT, ['lastId'=> $lastId]);  
             }
            else          
            { 
                Util:: jsonResponse('error', ERROR_INSERT);                        
            }
        } 
        catch (Exception $e)
        {
            Util::jsonResponse('error', $e->getMessage() );                 
        }
    }


    private function updateAction($equipo_id, $params)
    {
        try {
            $fields = [
                'ns',
                'PIN',
                'Descriptor',
                'numero_corto',
                'numero_largo',
                'diferenciahoraria',
                'estudiarcomm',
                'estudiaralim',
                'asp',
                'instalador',
                'tipoinstalacion',
                'instalacion',
                'asp'
            ];

            $data = [];
            foreach ($fields as $field) {
                $data[$field] = isset($params[$field]) ? UtilParams::sanitizeString($params[$field]) : '';
            }

            // validacion minima
            if (empty($equipo_id) ) {
                throw new Exception('Datos incompletos');
            }

            $updated = $this->equipos_model->update($equipo_id, $data );
    
            if ($updated)
            {
                $lastId = $this->equipos_model->lastId();
                Util:: jsonResponse('success', SUCCESS_UPDATE, ['lastId'=> $lastId]);  
            }
            else
            {
               Util:: jsonResponse('error', ERROR_UPDATE);
            }
        } 
        catch (Exception $e) {
            Util::jsonResponse('error', $e->getMessage() );
        }
    }

    private function deleteAction($equipo_id)
    {
      try {
            if (empty($equipo_id)) { throw new Exception('Datos incompletos');  }

            $success = $this->equipos_model->delete($equipo_id);
            if ($success)
             { Util:: jsonResponse('success', SUCCESS_DELETE);  }
            else 
             { Util:: jsonResponse('error', ERROR_DELETE); }
        } 
        catch (Exception $e) {
            Util::jsonResponse('error', $e->getMessage() );
        }        
    }



} // class
?>