<?php

class equipos_view
{
    private $instalacion_model;
    private $instalacion_tipo_model;
    private $instalador_model;

    public function __construct($container) {
        $this->instalacion_model      = $container->get('instalacion_model');
        $this->instalacion_tipo_model = $container->get('instalacion_tipo_model');
        $this->instalador_model       = $container->get('instalador_model');
    }


    public function showFilter($filters, $level, $asp )
    {
        $instalacion_tipos = $this->instalacion_tipo_model->get_instalacion_tipos($asp, true);
        $instaladores      = $this->instalador_model->get_instaladores($asp, true);


        $html = "";
        $html .= "<div class='container-fluid filters shadow'>";
        $html .= "<div class='row  mb-2 justify-content-center'>";           
        $html .= util_html_filter::filter_search( 
            'search', 
            $filters['search'],  
            'Buscar Instalacion', 
            'filter_equipos');

        $html .= util_html_filter::filter_select(
            'filter_instalacion_tipo', 
            'Instalacion Tipo', 
            $instalacion_tipos, 
            $filters['filter_instalacion_tipo'], 
            'value1', 'text', 'col-sm-1', 'filter_equipos', false);

        $html .= util_html_filter::filter_select(
            'filter_instalador', 
            'Instalador', 
            $instaladores, 
            $filters['filter_instalador'], 
            'value1', 'text', 'col-sm-1', 'filter_equipos', false);

        $html .= util_html_filter::filter_checkbox(
            'filter_equipos_nocomm', 
            $filters['filter_equipos_nocomm'],  
            'Equipos Sin Comunicacion',
            'filter_equipos');

        $html .= util_html_filter::filter_select(
            'pag_limit', 
            '', 
            util_html_filter::get_limitOptions(), 
            $filters['pag_limit'], 
            'value1', 'text', 'col-sm-1', 'filter_equipos', false);

        $html .= "</div>"; 
        $html .= "</div>"; 
        return $html;
    }


    public function showAll($filters, $level, $asp, $result)
    {
        $insertButton =  util_html_button::button('create', 'equipos_insertButton' ); 

        $html = "";
        $html .= "<div class='outer_div shadow'>";
        $html .= "<div class='table-responsive'>";
        $html .= "<table border=1 id='equipos_table' class='table table-striped table-hover' style='font-size:14px; white-space:nowrap;'>";

        $html .= "<thead>";
        $html .= "<tr class='row2'>";
       
        $html .= util_html_table::th($filters, 'instalacion_nombre'         , 'Instalacion',        'equipos_sort');
        $html .= util_html_table::th($filters, 'instalacion_tipo_nombre'    , 'Instalacion Tipo',   'equipos_sort');
        $html .= util_html_table::th($filters, 'instalador_nombre'          , 'Instalador',         'equipos_sort');
        $html .= util_html_table::th($filters, 'Id'                         , 'Id',                 'equipos_sort');
        $html .= util_html_table::th($filters, 'ns'                         , 'ns',                 'equipos_sort');
        $html .= util_html_table::th($filters, 'IP'                         , 'IP',                 'equipos_sort');
        $html .= util_html_table::th($filters, 'UltimaRecepcion'            , 'Ultima Recepcion',   'equipos_sort');
        $html .= util_html_table::th($filters, 'PIN'                        , 'PIN',                'equipos_sort');
        $html .= util_html_table::th($filters, 'Descriptor'                 , 'Descriptor',         'equipos_sort');
        if ($level === 4) { $html .= util_html_table::th($filters, 'id_motorcom',  'id_motorcom 4',   'equipos_sort'); }
        if ($level === 4) { $html .= util_html_table::th($filters, 'asp',  'asp 4',                   'equipos_sort'); }
        if ($level > 2) { $html .= "<th colspan=2 class='text-center'>".$insertButton."</th>"; }

        /*
        ref util_html_table::th($sort, $field, $label, $class, $style, $js);
        $html .= util_html_table::th($filters, 'instalacion',  'Instalacion',     'equipos_sort');
        $html .= util_html_table::th($filters, 'instalacion_tipo',  'Instalacion Tipo',     'equipos_sort');
        $html .= util_html_table::th($filters, 'instalador',  'Instalador',     'equipos_sort');
        $html .= util_html_table::th($filters, 'IP_Equipo', 'IP Equipo',   'equipos_sort');
        $html .= util_html_table::th($filters, 'lastip',    'lastip',     'equipos_sort');
        $html .= util_html_table::th($filters, 'Puerto_Equipo',  'Puerto_Equipo',     'equipos_sort');
        $html .= util_html_table::th($filters, 'Columna3',  'Columna3',     'equipos_sort');
        $html .= util_html_table::th($filters, 'UltimoRegistro',  'UltimoRegistro',     'equipos_sort');
        $html .= util_html_table::th($filters, 'MinMaxSinPq',  'MinMaxSinPq',     'equipos_sort');
        $html .= util_html_table::th($filters, 'BytesTx',  'BytesTx',     'equipos_sort');
        $html .= util_html_table::th($filters, 'BytesRx',  'BytesRx',     'equipos_sort');
        $html .= util_html_table::th($filters, 'NCambiosIP',  'NCambiosIP',     'equipos_sort');
        $html .= util_html_table::th($filters, 'UltimaPeticion',  'UltimaPeticion',     'equipos_sort');
        $html .= util_html_table::th($filters, 'Cuarentena',  'Cuarentena',     'equipos_sort');
        $html .= util_html_table::th($filters, 'numero_corto',  'numero_corto',     'equipos_sort');
        $html .= util_html_table::th($filters, 'numero_largo',  'numero_largo',     'equipos_sort');
        $html .= util_html_table::th($filters, 'diferenciahoraria',  'diferenciahoraria',     'equipos_sort');
        $html .= util_html_table::th($filters, 'estudiarcomm',  'estudiarcomm',     'equipos_sort');
        $html .= util_html_table::th($filters, 'estudiarlim',  'estudiarlim',     'equipos_sort');
        */


        $html .= "</tr>";
        $html .= "</thead>";

        $html .= "<tbody>";
        if (!empty($result) && (is_array($result) || is_iterable($result)))         
        {
            foreach ($result as $row)
            {
                $html .= "<tr class='row2'>";
                $html .= util_html_table::td($row['instalacion_nombre']);
                $html .= util_html_table::td($row['instalacion_tipo_nombre']);
                $html .= util_html_table::td($row['instalador_nombre']);
                $html .= util_html_table::td($row['Id']);
                $html .= util_html_table::td($row['ns']);
                $html .= util_html_table::td($row['IP']);
                $html .= util_html_table::td($row['UltimaRecepcion']);
                $html .= util_html_table::td($row['PIN']);
                $html .= util_html_table::td($row['Descriptor']);
                if ($level === 4) { $html .= util_html_table::td($row['id_motorcom']); }
                if ($level === 4) { $html .= util_html_table::td($row['asp']); }
                
                $editButton =  util_html_button::button('Edit', 'equipos_editButton', ['id' => $row['Id']]  ); 
                $deleteButton =  util_html_button::button('Delete', 'equipos_delete', ['id' => $row['Id']]  ); 
                if ($level > 1)  { $html .= "<td>".$editButton."</td>"; }
                if ($level > 2)  { $html .= "<td>".$deleteButton."</td>"; }

                /*
                ref util_html_table::td($value, $class, $style);
                $html .= util_html_table::td($row['instalacion']);
                $html .= util_html_table::td($row['instalacion_tipo']);
                $html .= util_html_table::td($row['instalador']);
                $html .= util_html_table::td($row['IP_Equipo']);
                $html .= util_html_table::td($row['lastip']);
                $html .= util_html_table::td($row['Puerto_Equipo']);
                $html .= util_html_table::td($row['Columna 3']);
                $html .= util_html_table::td($row['UltimoRegistro']);
                $html .= util_html_table::td($row['MinMaxSinPq']);
                $html .= util_html_table::td($row['BytesTx']);
                $html .= util_html_table::td($row['BytesRx']);
                $html .= util_html_table::td($row['NCambiosIP']);
                $html .= util_html_table::td($row['UltimaPeticion']);
                $html .= util_html_table::td($row['Cuarentena']);
                $html .= util_html_table::td($row['numero_corto']);
                $html .= util_html_table::td($row['numero_largo']);
                $html .= util_html_table::td($row['diferenciahoraria']);
                $html .= util_html_table::td($row['estudiarcomm']);
                $html .= util_html_table::td($row['estudiaralim']);
                */
                
                $html .= "</tr>";
            }
            $html .= "</tbody>";
         }

        $html .= "</table>";
        $html .= "</div>";
        $html .= "</div>";

        return $html;
        
    }


    // formulario de edicion
    // input_text($id, $field, $value, $label, $class, $style)
    // select($data_locked, $data_id, $data_field, $data_action, $options, $valueField, $valueSelected, $textField)
    public function showId($result, $level,$asp, $usuario)
    {
        $instalaciones     = $this->instalacion_model->get_instalaciones_options($asp,$usuario['id'], false);
        $instaladores      = $this->instalador_model->get_instaladores($asp, false);
        $instalacion_tipos = $this->instalacion_tipo_model->get_instalacion_tipos($asp, false);

        $output = "";
        $output .= "<div class='container d-flex flex-column align-items-center mt-4'>";
        
        if ($level === 4) { 
            $output .= util_html_form::input_text('Id'               , $result['Id']                , 'Id 4');
        }
        else {
            $output .= util_html_form::input_text_hidden('Id'               , $result['Id']                , 'Id 4');
        }
        $output .= util_html_form::input_text('ns'               , $result['ns']                , 'ns');
        $output .= util_html_form::input_text('PIN'              , $result['PIN']               , 'PIN');
        $output .= util_html_form::input_text('Descriptor'       , $result['Descriptor']        , 'Descriptor');
        $output .= util_html_form::input_text('numero_corto'     , $result['numero_corto']      , 'Numero Corto');
        $output .= util_html_form::input_text('numero_largo'     , $result['numero_largo']      , 'Numero Largo');
        $output .= util_html_form::input_text('diferenciahoraria', $result['diferenciahoraria'] , 'Diferencia Horaria');
        $output .= util_html_form::input_text('estudiarcomm'     , $result['estudiarcomm']      , 'estudiarcomm');
        $output .= util_html_form::input_text('estudiaralim'     , $result['estudiaralim']      , 'estudiaralim');

        //        $output .= util_html_form::input_text('instalador'       , $result['instalador']        , 'instalador');
        $output .= util_html_form::select(
            'instalador', 
            'Instalador',
            $instaladores,
            $result['instalador'] 
            );

//        $output .= util_html_form::input_text('tipoinstalacion'  , $result['tipoinstalacion']   , 'tipoinstalacion');
        $output .= util_html_form::select(
            'tipoinstalacion', 
            'Instalacion Tipo',
            $instalacion_tipos,
            $result['tipoinstalacion'] 
            );

//        $output .= util_html_form::input_text('instalacion'      , $result['instalacion']       , 'instalacion');
        $output .= util_html_form::select(
            'instalacion', 
            'Instalacion',
            $instalaciones,
            $result['instalacion'] 
            );

        if ($level === 4) { 
            $output .= util_html_form::input_text('asp'              , $result['asp']               , 'asp 4');
        }
        else {
            $output .= util_html_form::input_text_hidden('asp'              , $result['asp']               , 'asp 4');
        }

        //        $output .= util_html_form::input_text('IP_Equipo'        , $result['IP_Equipo']         , 'IP_Equipo');
        //        $output .= util_html_form::input_text('IP'               , $result['IP']                , 'IP');
        //        $output .= util_html_form::input_text('lastip'           , $result['lastip']            ,'lastip' );
        //        $output .= util_html_form::input_text('Puerto_Equipo'    , $result['Puerto_Equipo']     , 'Puerto_Equipo');
        //        $output .= util_html_form::input_text('Columna 3'        , $result['Columna 3']         , 'Columna 3');
        //        $output .= util_html_form::input_text('UltimaRecepcion'  , $result['UltimaRecepcion']   , 'UltimaRecepcion');
        //        $output .= util_html_form::input_text('UltimoRegistro'   , $result['UltimoRegistro']    , 'UltimoRegistro');
        //        $output .= util_html_form::input_text('MinMaxSinPq'      , $result['MinMaxSinPq']       , 'MinMaxSinPq');
        //        $output .= util_html_form::input_text('BytesTx'          , $result['BytesTx']           , 'BytesTx');
        //        $output .= util_html_form::input_text('BytesRx'          , $result['BytesRx']           , 'BytesRx');
        //        $output .= util_html_form::input_text('NCambiosIP'       , $result['NCambiosIP']        , 'NCambiosIP');
        //        $output .= util_html_form::input_text('UltimaPeticion'   , $result['UltimaPeticion']    , 'UltimaPeticion');
        //        $output .= util_html_form::input_text('Cuarentena'       , $result['Cuarentena']        , 'Cuarentena');
        //        $output .= util_html_form::input_text('id_motorcom'      , $result['id_motorcom']       , 'id_motorcom');

        $output .= "<div class='w-50 text-center'>";        
        $output .= "<button type='button' onclick='equipos_update( {$result['Id']} )' class='btn btn-warning'>Update</button>";
        $output .= "</div>"; 

        $output .= "</div>";
        return $output;
    }

} // class
?>