// Estado global de instalacion
const instalacionState = {
    search: '',
    filter_showEquipos: 0,
    pag_page: 1,
    pag_limit: 10,
    sort_column: '',
    sort_direction: 'ASC',
    filter_instalador : -1
};

// Inizializa el estado desde la URL
function initStateFromUrl() {
    const params = new URLSearchParams(window.location.search);

    instalacionState.search             = params.get('search')   || '';
    instalacionState.pag_page           = parseInt(params.get('pag_page')) || 1;
    instalacionState.pag_limit          = parseInt(params.get('pag_limit')) || 10;
    instalacionState.sortColumn         = params.get('sort_column')   || 'nombre_inst';
    instalacionState.sortDirection      = params.get('sort_direction') || 'ASC';
    instalacionState.filter_instalador  = params.get('filter_instalador') || -1;
    instalacionState.filter_showEquipos = params.get('filter_showEquipos') || 0;

    // Actualiza inputs en la UI para reflejar el estado
    $('#search').val(instalacionState.search);
    $('#pag_limit').val(instalacionState.pag_limit);
    $('#filter_instalador').val(instalacionState.filter_instalador);
    $('#filter_showEquipos').val(instalacionState.filter_showEquipos);
}


// Actualiza URL desde el estado
function updateUrlFromState() {
    const params = new URLSearchParams({
        search:             instalacionState.search,
        pag_page:           instalacionState.pag_page,
        pag_limit:          instalacionState.pag_limit,
        sort_column:        instalacionState.sort_column,
        sort_direction:     instalacionState.sort_direction,
        filter_showEquipos: instalacionState.filter_showEquipos,
        filter_instalador:  instalacionState.filter_instalador
    });
    history.pushState({}, '', `${window.location.pathname}?${params.toString()}`);
}


// Cargar datos 
async function instalacion_loadData() {
    updateUrlFromState(); // sincroniza URL (opcional para la URL visible)

    const postData = new URLSearchParams({
        page: 'instalacion',
        action: 'instalacion_filter',
        search:             instalacionState.search,
        pag_page:           instalacionState.pag_page,
        pag_limit:          instalacionState.pag_limit,
        sort_column:        instalacionState.sort_column,
        sort_direction:     instalacionState.sort_direction,
        filter_showEquipos: instalacionState.filter_showEquipos,
        filter_instalador : instalacionState.filter_instalador
    });

//    alert(postData);

    try {
        const response = await fetch('mainframe.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded'
            },
            body: postData.toString()
        });

        if (!response.ok) throw new Error(`HTTP error! status: ${response.status}`);

        const data = await response.json();

        $('#instalacion_table').html(data.table);
        $('#instalacion_pag').html(data.pagination);

        // Ajustar paginación si totalRecords viene en la respuesta
        if (data.totalRecords) {
            const totalPages = Math.max(1, Math.ceil(data.totalRecords / instalacionState.pag_limit));
            if (instalacionState.pag_page > totalPages) {
                instalacionState.pag_page = totalPages;
                instalacion_loadData();
            }
        }
    } catch (err) {
        console.error('Error al cargar datos:', err);
    }
}


function instalacion_sort(field, dir) {
    instalacionState.sort_column = field;
    instalacionState.sort_direction = dir;
    instalacion_loadData();
}

// Función genérica para actualizar filtros
function instalacion_updateFilterField(fieldId, fieldValue) {
//    alert(fieldValue );
    instalacionState[fieldId] = fieldValue;
    instalacionState.pag_page = 1; // reinicia página cuando cambia un filtro
    instalacion_loadData();       
}


// =============================
// Document Ready
// =============================
$(document).ready(function () {
        // Asegurarse de que debounceTimers exista, si no, inicializarlo
    if (typeof debounceTimers === 'undefined') {
        debounceTimers = {}; // Inicializar si no existe
    }

    initStateFromUrl();
    instalacion_loadData();

    // evento para los filtros
    $('.filter_instalacion').on('input', function () {
        const fieldId    = $(this).attr('id'); // Identifica el campo que disparó el evento.
        let fieldValue;

        if ($(this).attr('type') === 'checkbox') {
            fieldValue = $(this).prop('checked') ? 1 : 0;
        } else {
            fieldValue = $(this).val();
        }

//        alert(fieldId + " " + fieldValue);

        clearTimeout(debounceTimers[fieldId]); // Limpia el temporizador anterior para este campo.
        debounceTimers[fieldId] = setTimeout(() => { 
            instalacion_updateFilterField(fieldId, fieldValue);
        }, 300); // El retraso es de 300 ms. Puedes ajustarlo según sea necesario.
    });

    // evento para paginación
    $(document).on('click', '.pagination-btn', function() {
        const page = parseInt($(this).data('page'));
        if (!isNaN(page)) {
            instalacionState.pag_page = page;
            instalacion_loadData(); // recarga vía AJAX con la nueva página
        }
    });    
});


async function instalacion_insert_button()
{
    try
    {
        const page   = 'instalacion';
        const action = 'instalacion_insert';

        const response = await fetch(`mainframe.php?page=${page}&action=${action}`, { method: 'GET' });
        if (!response.ok) { 
            throw new Error(`HTTP error! status: ${response.status}`); 
        }

        const data = await response.json();
        if (data.status === 'success')
        {
            instalacion_edit( data.lastId, () => {
                instalacion_loadData();                
            } );
        }
        else 
        { console.error(data.status); }           
    } 
    catch (error) {
        console.error('Error:', error);
    }
}


function instalacion_editButton(p)
{
    instalacion_edit (p.id_inst, () => {
       instalacion_loadData();            
    });
}

function instalacion_edit(id_inst, onClose) {
    const page   = 'instalacion';
    const action = 'instalacion_edit';

    $.ajax({
        url: 'mainframe.php', 
        type: 'GET',
        data: { page: page, action: action, id_inst: id_inst },
        success: function(response) {
            $('#modalFormContent').html(response); // Cargar el formulario dentro del modal
            $('#editModal').modal('show'); 

            $('#editModal').off('hidden.bs.modal').on('hidden.bs.modal', () => {
                console.log('Modal cerrado');
                if (typeof onClose === 'function') {
                    console.log('Modal cerrado callback');
                    onClose();
                }
              });            
        },
        error: function(xhr, status, error) {
            console.error('Error al obtener el formulario:', status, error);
        }
    });
}


async function instalacion_update(id_inst)
{
    const params = new URLSearchParams();

    params.append("id_inst", id_inst);
    params.append("ref_inst", document.getElementById("ref_inst").value);
    params.append("nombre_inst", document.getElementById("nombre_inst").value);
    params.append("instalador", document.getElementById("instalador").value);
    params.append("notas_inst", document.getElementById("notas_inst").value);
    params.append("email_inst", document.getElementById("email_inst").value);
    params.append("logo_cliente_inst", document.getElementById("logo_cliente_inst").value);
    params.append("web_cliente", document.getElementById("web_cliente").value);
    params.append("direccion", document.getElementById("direccion").value);
    params.append("localidad", document.getElementById("localidad").value);
    params.append("provincia", document.getElementById("provincia").value);
    params.append("pais", document.getElementById("pais").value);
    params.append("CP", document.getElementById("CP").value);
    params.append("Tlf", document.getElementById("Tlf").value);
    params.append("lat", document.getElementById("lat").value);
    params.append("lon", document.getElementById("lon").value);
    params.append("asp", document.getElementById("asp").value);

//    alert(params);

    try
    {
        page   = 'instalacion',
        action = 'instalacion_update'

        const response = await fetch(`mainframe.php?page=${page}&action=${action}`, {
            method: 'POST',
            headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
            body: params.toString()            
        });

        if (!response.ok) { throw new Error(`HTTP error! status: ${response.status}`); }

        const data = await response.json();
        if (data.status === 'success')
        {
            hideModal();
        }
        else 
        {
            console.error(data.message);            
        }
    }
    catch (error) {
        console.error('Error:', error);
    }
}

async function instalacion_delete(p)
{
    try
    {
        const confirmDelete = confirm("Are you sure to delete this instalacion?" + p.id_inst);
        if (!confirmDelete) {
            return; 
        }

        const page   = 'instalacion';
        const action = 'instalacion_delete';

        const response = await fetch(`mainframe.php?page=${page}&action=${action}&id_inst=${p.id_inst}`);
        if (!response.ok) { 
            throw new Error(`HTTP error! status: ${response.status}`); 
        }

        const data = await response.json();
        if (data.status === 'success')
        {
             instalacion_loadData();                
        }
        else {
             console.error('Error:', error); 
            }
    }
    catch (error) {
        console.error('Error:', error);
    }
}

function hideModal() {
//    alert("hideModal1")
    $('#editModal').modal('hide'); // Usar el método de Bootstrap
    instalacion_loadData();
}

