<?php

class instalacion_model
{
    private $conexion;
    
    public function __construct($conexion)
    {
        $this->conexion = $conexion;
    }
    
    public function count($filters)
    {
        $sql = " SELECT COUNT(*) AS total";
        $sql .= " FROM vista_instalacion";
        $sql .= " WHERE 1=1 ";
        $params = [];
        $types = "";

        $sql .= $this->build_filters($filters, $params, $types);

        try {
            $stmt = UtilSQL::executeQuery($this->conexion, $sql, $params, $types);

            $sqlResult = $stmt->get_result();
            $stmt->close();

            $fila = $sqlResult->fetch_assoc();
            return $fila['total'];
        } 
        catch (Exception $e) {
            return "Error al obtener el total: " . $e->getMessage();
        }
    }


    public function selectAll($filters, $paginar = true, $filtrar =true)
    {
        $sql = " SELECT * ";
        $sql .= " FROM vista_instalacion";
        $sql .= " WHERE 1=1 ";
        $params = [];
        $types = "";

        if ($filtrar) {
            $sql .= $this->build_filters($filters, $params, $types);
            $sql .= UtilSQL::build_sort($filters);
        }
        if ($paginar) {
             $sql .= UtilSQL::build_paginacion($filters, $params, $types); 
        }

//        Tools::debugTXT( $sql );

        try {
            $stmt = UtilSQL::executeQuery($this->conexion, $sql, $params, $types);

            $sqlResult = $stmt->get_result();
            $stmt->close();

            $result = [];
            while ($fila = $sqlResult->fetch_assoc()) {
                $result[] = $fila;
            }
            return $result;
        } 
        catch (Exception $e) {
            return "Error al obtener los registros: " . $e->getMessage();
        }
    }


    public function select($id)
    {
        $sql = "SELECT * FROM instalacion WHERE id_inst = ?";

        try {
            $stmt = $this->conexion->prepare($sql);
            $stmt->bind_param("i", $id);

            if (!$stmt->execute()) {
                die('Error en la ejecución de la consulta SQL: ' . $stmt->error);
            }

            $sqlResult = $stmt->get_result();
            $stmt->close();

            $result = [];
            while ($fila = $sqlResult->fetch_assoc()) {
                $result[] = $fila;
            }
            return $result;
        }
        catch (mysqli_sql_exception $e) {
            error_log("Error en consulta SELECT: " . $e->getMessage()); // Guardar en log de errores
            return "Error al obtener el registro: " . $e->getMessage(); // Mensaje amigable para el usuario
        }
    }



    public function get_instalacion_equipos($instalacion)
    {
        $sql = "SELECT * FROM equipos WHERE instalacion = ?";

        try {
            $stmt = $this->conexion->prepare($sql);
            $stmt->bind_param("i", $instalacion);

            if (!$stmt->execute()) {
                die('Error en la ejecución de la consulta SQL: ' . $stmt->error);
            }

            $sqlResult = $stmt->get_result();
            $stmt->close();

            $result = [];
            while ($fila = $sqlResult->fetch_assoc()) {
                $result[] = $fila;
            }
            return $result;
        } 
        catch (mysqli_sql_exception $e) {
            error_log("Error en consulta SELECT: " . $e->getMessage()); // Guardar en log de errores
            return "Error al obtener el registro: " . $e->getMessage(); // Mensaje amigable para el usuario
        }
    }



    public function insert($nombre_inst) {
        
        $sql = "INSERT INTO instalacion (nombre_inst) VALUES (?)";

        $stmt = $this->conexion->prepare($sql);

        if (!$stmt) {
            die('Error en la preparación de la consulta SQL: ' . $this->conexion->error);
        }

        $stmt->bind_param("s", $nombre_inst);

        if (!$stmt->execute()) {
            die('Error al ejecutar la consulta SQL: ' . $stmt->error);
        }

        // obtiene el ultimo valor autoincrementado
        $newId = $this->conexion->insert_id;

        $stmt->close();
        return $newId;
    }

    public function insert_acl_usuarios_instalaciones($id_user, $id_instalacion) {
        
        $sql = "INSERT INTO acl_usuarios_instalaciones (id_user, id_instalacion) VALUES (?,?)";

        $stmt = $this->conexion->prepare($sql);

        if (!$stmt) {
            die('Error en la preparación de la consulta SQL: ' . $this->conexion->error);
        }

        $stmt->bind_param("ii", $id_user, $id_instalacion);

        if (!$stmt->execute()) {
            die('Error al ejecutar la consulta SQL: ' . $stmt->error);
        }

        $stmt->close();
        return true;
    }


    public function delete_acl_usuarios_instalaciones($id_inst) {
        
        $sql = "DELETE FROM acl_usuarios_instalaciones WHERE id_instalacion = ? ";
        $stmt = $this->conexion->prepare($sql);

        if (!$stmt) {
            die('Error en la preparación de la consulta SQL: ' . $this->conexion->error);
        }

        $stmt->bind_param("i", $id_inst);
        if (!$stmt->execute()) {
            die('Error al ejecutar la consulta SQL: ' . $stmt->error);
        }

        $stmt->close();
        return true;
    }

    public function delete($id_inst) {
        
        $sql = "DELETE FROM instalacion WHERE id_inst = ? ";
        $stmt = $this->conexion->prepare($sql);

        if (!$stmt) {
            die('Error en la preparación de la consulta SQL: ' . $this->conexion->error);
        }

        $stmt->bind_param("i", $id_inst);
        if (!$stmt->execute()) {
            die('Error al ejecutar la consulta SQL: ' . $stmt->error);
        }

        $stmt->close();
        return true;
    }

    public function update($id_inst, $data) {
        
        $sql = "UPDATE instalacion SET 
                ref_inst = ?, 
                nombre_inst = ?, 
                notas_inst = ?, 
                email_inst = ?, 
                logo_cliente_inst = ?, 
                web_cliente = ?, 
                direccion = ?, 
                localidad = ?, 
                provincia = ?, 
                pais = ?, 
                Tlf = ?, 
                instalador = ?, 
                CP = ?, 
                lat = ?, 
                lon = ?,
                asp = ?
            WHERE id_inst = ?";

        $stmt = $this->conexion->prepare($sql);
        if (!$stmt) {
            die('Error en la preparación de la consulta SQL: ' . $this->conexion->error);
        }

        $stmt->bind_param(
            "sssssssssssiiiiii",            
            $data['ref_inst'],
            $data['nombre_inst'],
            $data['notas_inst'],
            $data['email_inst'],
            $data['logo_cliente_inst'],
            $data['web_cliente'],
            $data['direccion'],
            $data['localidad'],
            $data['provincia'],
            $data['pais'],
            $data['Tlf'],
            $data['instalador'],
            $data['CP'],
            $data['lat'],
            $data['lon'],
            $data['asp'],
            $id_inst
        );        
        if (!$stmt->execute()) {
            die('Error al ejecutar la consulta SQL: ' . $stmt->error);
        }

        $stmt->close();
        return true;
    }


    private function build_filters($filters, &$params, &$types)
    {
        $sql = "";

        if ( isset($filters['search']) && ($filters['search'] != '') ) {
            $searchValue = $filters['search'];
            $sql .= " AND nombre_inst LIKE ?";
            $params[] = "%" . $searchValue . "%";
            $types .= "s";
        }

        if ( isset($filters['filter_instalaciones'])  ) {
            $sql .= " AND id_inst IN (" . implode(',', array_fill(0, count($filters['filter_instalaciones']), '?')) . ")";
            $params = array_merge($params, $filters['filter_instalaciones']);
            $types .= str_repeat('i', count($filters['filter_instalaciones'])); // si son enteros            
        }

        if ( isset($filters['filter_instalador']) && $filters['filter_instalador'] != '-1' ) {
            $sql .= " AND instalador = ? ";
            $params[] = (int)$filters['filter_instalador'];
            $types .= "i";
        }

        if ( isset($filters['filter_asp']) && $filters['filter_asp'] != '-1' ) {
            $sql .= " AND asp = ? ";
            $params[] = (int)$filters['filter_asp'];
            $types .= "i";
        }

        return $sql;
    }


    public function get_instalaciones_iduser($id_user)  {
        
        $sql = "SELECT id_instalacion FROM vista_usuarios_instalaciones WHERE id_user = ?";

        try {
            $stmt = $this->conexion->prepare($sql);
            $stmt->bind_param("i", $id_user);

            if (!$stmt->execute()) {
                die('Error en la ejecución de la consulta SQL: ' . $stmt->error);
            }

            $sqlResult = $stmt->get_result();
            $stmt->close();

            $result = [];
            while ($fila = $sqlResult->fetch_assoc()) {
                $result[] = $fila;
            }
            return $result;
        } 
        catch (mysqli_sql_exception $e) {
            error_log("Error en consulta SELECT: " . $e->getMessage()); // Guardar en log de errores
            return "Error al obtener el registro: " . $e->getMessage(); // Mensaje amigable para el usuario
        }
    }


    public function get_instalaciones_array($id_user){

        $instalaciones = $this->get_instalaciones_iduser( $id_user );

        $result = [];
        foreach($instalaciones as $instalacion) {
            $result[] = $instalacion['id_instalacion'];
        }
        return $result;
    }


    // devolvemos un array con todos los instaladores, para las vistas del filtro, y edicion
    public function get_instalaciones_options($asp, $id_user, $includeTodos = true) {
        $instalaciones_del_usuario = $this->get_instalaciones_array($id_user);
        $tmp = $this->selectAll([], false, false);
        

        // filtramos para que devuelve solo las instalaciones del usuario, no todas
        $tmp = array_filter($tmp, function($instalacion) use ($instalaciones_del_usuario) {
            return in_array($instalacion['id_inst'], $instalaciones_del_usuario);
        });        
//        print_r($tmp);



        // filtrar por asp == 1
        if ($asp != -1) {
            $tmp = array_filter($tmp, function($item) use ($asp) {
                return $item['asp'] == $asp;
            });            
        }


        $result = [];

        if ($includeTodos) {
            $result = [
                [
                    'id'     => -1,        // puedes usar -1 o cualquier valor que indique "todos"
                    'value1' => -1,         // o null
                    'text'   => '[ Todos ]'
                ]
            ];
        }

        $index = 0;
        foreach($tmp as $item)
        {
            $result[] =
             [
                'id'     => $index,
                'value1' => $item['id_inst'],
                'text'   => $item['nombre_inst']
             ];
            $index++;
        }

        return $result;
    }


} // class
