<?php

class instalacion_view
{
    private $instalacion_model;
    private $instalador_model;

    public function __construct($container)
    {
        $this->instalacion_model     = $container->get('instalacion_model');
        $this->instalador_model      = $container->get('instalador_model');
    }



    public function showFilter($filters, $level, $asp ) {   
        $instaladores = $this->instalador_model->get_instaladores($asp, true);

        $html = "";
        $html .= "<div class='container-fluid filters shadow'>";
        $html .= "<div class='row  mb-2 justify-content-center'>";           
        $html .= util_html_filter::filter_search( 
            'search', 
            $filters['search'],  
            'Search', 
            'filter_instalacion');

        $html .= util_html_filter::filter_select(
            'filter_instalador', 
            'Instalador', 
            $instaladores, 
            $filters['filter_instalador'], 
            'value1', 'text', 'col-sm-1', 'filter_instalacion', false);

        $html .= util_html_filter::filter_checkbox(
            'filter_showEquipos', 
            $filters['filter_showEquipos'],  
            'Show Equipos',
            'filter_instalacion');

        $html .= util_html_filter::filter_select(
            'pag_limit', 
            '', 
            util_html_filter::get_limitOptions(), 
            $filters['pag_limit'], 
            'value1', 'text', 'col-sm-1', 'filter_instalacion', false);

        $html .= "</div>"; 
        $html .= "</div>"; 
        return $html;
    }


    public function showAll($filters, $level, $asp, $result)
    {
        $insertButton =  util_html_button::button('create', 'instalacion_insert_button' ); 

        $html = "";
        $html .= "<div class='outer_div shadow'>";
        $html .= "<div class='table-responsive'>";
        $html .= "<table border=1 id='instalacion_table' class='table table-striped table-hover' style='font-size:14px; white-space:nowrap;'>";

        $html .= "<thead>";
        $html .= "<tr class='row2'>";
        
        if ($level === 4) { $html .= util_html_table::th($filters, 'id_inst',           'id_inst 4',  'instalacion_sort'); }
        $html .= util_html_table::th($filters, 'ref_inst',          'Referencia', 'instalacion_sort');
        $html .= util_html_table::th($filters, 'nombre_inst',       'Nombre',   'instalacion_sort');
        $html .= util_html_table::th($filters, 'web_cliente',       'Web',      'instalacion_sort');
        $html .= util_html_table::th($filters, 'instalador_name', 'Instalador', 'instalacion_sort'); // vista
        $html .= util_html_table::th($filters, 'notas_inst', 'Notas', 'instalacion_sort');
        if ($level === 4) { $html .= util_html_table::th($filters, 'asp', 'asp 4', 'instalacion_sort'); }
        if ($level > 2) { $html .= "<th colspan=2 class='text-center'>".$insertButton."</th>";  }
        
            /*
            // ref util_html_table::th($sort, $field, $label, $class, $style, $js);
            $html .= util_html_table::th($filters, 'logo_cliente_inst', 'Logo',     'instalacion_sort');
            $html .= util_html_table::th($filters, 'foto_instalacion',  'Foto',     'instalacion_sort');
            $html .= util_html_table::th($filters, 'direccion', 'Dirección', 'instalacion_sort');
            $html .= util_html_table::th($filters, 'localidad', 'Localidad', 'instalacion_sort');
            $html .= util_html_table::th($filters, 'provincia', 'Provincia', 'instalacion_sort');
            $html .= util_html_table::th($filters, 'pais', 'Pais', 'instalacion_sort');
            $html .= util_html_table::th($filters, 'CP', 'Codigo Postal', 'instalacion_sort');
            $html .= util_html_table::th($filters, 'Tlf', 'Teléfono', 'instalacion_sort');
            $html .= util_html_table::th($filters, 'husohorario', 'Huro Horario', 'instalacion_sort');
            $html .= util_html_table::th($filters, 'lat', 'Latitud', 'instalacion_sort');
            $html .= util_html_table::th($filters, 'lon', 'Longitud', 'instalacion_sort');
            $html .= util_html_table::th($filters, 'instalador', 'Intalador', 'instalacion_sort');
            $html .= util_html_table::th($filters, 'email_inst', 'Instalación Email', 'instalacion_sort');
            */

        $html .= "</tr>";
        $html .= "</thead>";

        $html .= "<tbody>";
        if (!empty($result) && (is_array($result) || is_iterable($result)))         
        {
            foreach ($result as $row)
            {
                $html .= "<tr class='row2'>";
                if ($level === 4 ) { $html .= util_html_table::td($row['id_inst']); }
                $html .= util_html_table::td($row['ref_inst']);
                $html .= util_html_table::td($row['nombre_inst']);
                $html .= "<td><a href='#' onclick=\"parent.loadUrlInIframe('" . $row['web_cliente'] ."', '".$row['id_inst']. "')\">" . $row['web_cliente'] . "</a></td>";
                $html .= util_html_table::td($row['instalador_name']);
                $html .= util_html_table::td($row['notas_inst']);
                if ($level === 4 ) { $html .= util_html_table::td($row['asp']); }

                $editButton =  util_html_button::button('Edit', 'instalacion_editButton', ['id_inst' => $row['id_inst']]  ); 
                $deleteButton =  util_html_button::button('Delete', 'instalacion_delete', ['id_inst' => $row['id_inst']]  ); 
                if ($level > 1) { $html .= "<td>".$editButton."</td>"; }
                if ($level > 2) { $html .= "<td>".$deleteButton."</td>"; }

                    /*
                    // ref util_html_table::td($value, $class, $style);
                    $html .= util_html_table::td($row['web_cliente']);
                    $html .= "<td>".util_html_table::td($row['web_cliente'])</td>;
                    $html .= "<td><a href='" . $row['web_cliente'] . "?page=ext' target='_blank'>" . $row['web_cliente'] . "</a></td>";
                    $html .= util_html_table::td($row['logo_cliente_inst']);
                    $html .= util_html_table::td($row['foto_instalacion']);
                    $html .= util_html_table::td($row['direccion']);
                    $html .= util_html_table::td($row['localidad']);
                    $html .= util_html_table::td($row['provincia']);
                    $html .= util_html_table::td($row['pais']);
                    $html .= util_html_table::td($row['CP']);
                    $html .= util_html_table::td($row['Tlf']);
                    $html .= util_html_table::td($row['husohorario']);
                    $html .= util_html_table::td($row['lat']);
                    $html .= util_html_table::td($row['lon']);
                    $html .= util_html_table::td($row['instalador']);
                    $html .= util_html_table::td($row['email_inst']);
                    */
                
                $html .= "</tr>";

                // Show equipos de la instalacion
                if ($filters['filter_showEquipos'] === '1') {
                    $equiposview = $this->show_equipos_instalacion($row['id_inst']);

                    $html .= "<tr><td colspan=4>"."</td></tr>";
                    $html .= "<tr><td colspan=2>".$equiposview."</td></tr>";
                }

            }
            $html .= "</tbody>";
         }

        $html .= "</table>";
        $html .= "</div>";
        $html .= "</div>";

        return $html;
    }

    // devuelve una tabla con los equipos de una instalacion
    private function show_equipos_instalacion($id_inst)
    {
        $equipos = $this->instalacion_model->get_instalacion_equipos($id_inst);
        $equiposview = "<table>";

                    /*
                    $equiposview .= "<tr>";
                    $equiposview .= "<th>"."Id"."</th>";
                    $equiposview .= "<th>"."Descriptor"."</th>";
                    $equiposview .= "<th>"."IP"."</th>";
                    $equiposview .= "<th>"."Puerto_Equipo"."</th>";
                    $equiposview .= "</tr>";
                    */
        foreach($equipos as $equipo)
        {
            $equiposview .= "<tr>";
            $equiposview .= "<td style='color:blue;'>".$equipo['Id']."</td>";
            $equiposview .= "<td style='color:blue;'>".$equipo['Descriptor']."</td>";
            $equiposview .= "<td style='color:blue;'>".$equipo['IP']."</td>";
            $equiposview .= "<td style='color:blue;'>".$equipo['Puerto_Equipo']."</td>";
            $equiposview .= "</tr>";
        }
        $equiposview .= "</table>";
        return $equiposview;
    }



    // formulario de edicion
    // input_text($id, $field, $value, $label, $class, $style)
    // select($data_locked, $data_id, $data_field, $data_action, $options, $valueField, $valueSelected, $textField)
    public function showId($result, $level, $asp)
    {
        $instaladores  = $this->instalador_model->get_instaladores($asp, false);

        $output = "";
        $output .= "<div class='container d-flex flex-column align-items-center mt-4'>";
        $output .= "<div class='row'>";

        $output .= "<div class='col-md-6 mb-3'>";
        if ($level === 4) {
            $output .= util_html_form::input_text('ins_inst', $result['id_inst'], 'Id Instalación 4', '', 'width:100px;');
            $output .= util_html_form::input_text('asp'              , $result['asp']               , 'asp 4');
        }
        else {
            $output .= util_html_form::input_text_hidden('ins_inst', $result['id_inst'], 'Id Instalación 4', '', 'width:100px;');
             $output .= util_html_form::input_text_hidden('asp'              , $result['asp']               , 'asp 4');
        }
        $output .= util_html_form::input_text('ref_inst', $result['ref_inst'], 'Referencia', '', 'width:100px;');
        $output .= util_html_form::input_text('nombre_inst', $result['nombre_inst'], 'Instalacion');

        //$output .= util_html_form::input_text('instalador', $result['instalador'], 'Instalador', '', 'width:100px;');
        $output .= util_html_form::select(
            'instalador', 
            'Instalador',
            $instaladores,
            $result['instalador'] 
            );

        $output .= util_html_form::input_text('notas_inst', $result['notas_inst'], 'Notas');
        $output .= util_html_form::input_text('email_inst', $result['email_inst'], 'Email');
        $output .= util_html_form::input_text('logo_cliente_inst', $result['logo_cliente_inst'], 'Logo');
        $output .= util_html_form::input_text('web_cliente', $result['web_cliente'], 'Web');
        $output .= "</div>"; 

        $output .= "<div class='col-md-6 mb-3'>";
        $output .= util_html_form::input_text('direccion', $result['direccion'], 'Dirección');
        $output .= util_html_form::input_text('localidad', $result['localidad'], 'Localidad');
        $output .= util_html_form::input_text('provincia', $result['provincia'], 'Provincia');
        $output .= util_html_form::input_text('pais', $result['pais'], 'Pais');
        $output .= util_html_form::input_text('CP', $result['CP'], 'Cod.Postal');
        $output .= util_html_form::input_text('Tlf', $result['Tlf'], 'Teléfono');
        $output .= util_html_form::input_text('lat', $result['lat'], 'Latitud', '', 'width:100px;');
        $output .= util_html_form::input_text('lon', $result['lon'], 'Longitud', '', 'width:100px;');
        $output .= "</div>"; 
        
        $output .= "</div>"; 

        $output .= "<div class='w-50 text-center'>";        
        $output .= "<button type='button' onclick='instalacion_update( {$result['id_inst']} )' class='btn btn-warning'>Update</button>";
        $output .= "</div>"; 

        $output .= "</div>";
        return $output;
    }

} // class
?>