// Estado global de instalador
const instaladorState = {
    search: '',
    pag_page: 1,
    pag_limit: 10,
    sort_column: '',
    sort_direction: 'ASC'
};

// Inizializa el estado desde la URL
function initStateFromUrl() {
    const params = new URLSearchParams(window.location.search);

    instaladorState.search             = params.get('search')   || '';
    instaladorState.pag_page           = parseInt(params.get('pag_page')) || 1;
    instaladorState.pag_limit          = parseInt(params.get('pag_limit')) || 10;
    instaladorState.sortColumn         = params.get('sort_column')   || 'nombre_inst';
    instaladorState.sortDirection      = params.get('sort_direction') || 'ASC';

    // Actualiza inputs en la UI para reflejar el estado
    $('#search').val(instaladorState.search);
    $('#pag_limit').val(instaladorState.pag_limit);
}


// Actualiza URL desde el estado
function updateUrlFromState() {
    const params = new URLSearchParams({
        search:             instaladorState.search,
        pag_page:           instaladorState.pag_page,
        pag_limit:          instaladorState.pag_limit,
        sort_column:        instaladorState.sort_column,
        sort_direction:     instaladorState.sort_direction
    });
    history.pushState({}, '', `${window.location.pathname}?${params.toString()}`);
}


// Cargar datos 
async function instalador_loadData() {
    updateUrlFromState(); // sincroniza URL (opcional para la URL visible)

    const postData = new URLSearchParams({
        page: 'instalador',
        action: 'instalador_filter',
        search:             instaladorState.search,
        pag_page:           instaladorState.pag_page,
        pag_limit:          instaladorState.pag_limit,
        sort_column:        instaladorState.sort_column,
        sort_direction:     instaladorState.sort_direction
    });

//    alert(postData);

    try {
        const response = await fetch('mainframe.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded'
            },
            body: postData.toString()
        });

        if (!response.ok) throw new Error(`HTTP error! status: ${response.status}`);

        const data = await response.json();

        $('#instalador_table').html(data.table);
        $('#instalador_pag').html(data.pagination);

        // Ajustar paginación si totalRecords viene en la respuesta
        if (data.totalRecords) {
            const totalPages = Math.max(1, Math.ceil(data.totalRecords / instaladorState.pag_limit));
            if (instaladorState.pag_page > totalPages) {
                instaladorState.pag_page = totalPages;
                instalador_loadData();
            }
        }
    } catch (err) {
        console.error('Error al cargar datos:', err);
    }
}


function instalador_sort(field, dir) {
    instaladorState.sort_column = field;
    instaladorState.sort_direction = dir;
    instalador_loadData();
}

// Función genérica para actualizar filtros
function instalador_updateFilterField(fieldId, fieldValue) {
//    alert(fieldValue );
    instaladorState[fieldId] = fieldValue;
    instaladorState.pag_page = 1; // reinicia página cuando cambia un filtro
    instalador_loadData();       
}


// =============================
// Document Ready
// =============================
$(document).ready(function () {
        // Asegurarse de que debounceTimers exista, si no, inicializarlo
    if (typeof debounceTimers === 'undefined') {
        debounceTimers = {}; // Inicializar si no existe
    }

    initStateFromUrl();
    instalador_loadData();

    // evento para los filtros
    $('.filter_instalador').on('input', function () {
        const fieldId    = $(this).attr('id'); // Identifica el campo que disparó el evento.
        let fieldValue;

        if ($(this).attr('type') === 'checkbox') {
            fieldValue = $(this).prop('checked') ? 1 : 0;
        } else {
            fieldValue = $(this).val();
        }

//        alert(fieldId + " " + fieldValue);

        clearTimeout(debounceTimers[fieldId]); // Limpia el temporizador anterior para este campo.
        debounceTimers[fieldId] = setTimeout(() => { 
            instalador_updateFilterField(fieldId, fieldValue);
        }, 300); // El retraso es de 300 ms. Puedes ajustarlo según sea necesario.
    });

    // evento para paginación
    $(document).on('click', '.pagination-btn', function() {
        const page = parseInt($(this).data('page'));
        if (!isNaN(page)) {
            instaladorState.pag_page = page;
            instalador_loadData(); // recarga vía AJAX con la nueva página
        }
    });    
});


async function instalador_insert_button()
{
    try
    {
        const page   = 'instalador';
        const action = 'instalador_insert';

        const response = await fetch(`mainframe.php?page=${page}&action=${action}`, { method: 'GET' });
        if (!response.ok) { 
            throw new Error(`HTTP error! status: ${response.status}`); 
        }

        const data = await response.json();
        if (data.status === 'success')
        {
            instalador_edit( data.lastId, () => {
                instalador_loadData();                
            } );
        }
        else 
        { console.error(data.status); }           
    } 
    catch (error) {
        console.error('Error:', error);
    }
}


function instalador_editButton(p)
{
    instalador_edit (p.id, () => {
       instalador_loadData();            
    });
}

function instalador_edit(id, onClose) {
    const page   = 'instalador';
    const action = 'instalador_edit';

    $.ajax({
        url: 'mainframe.php', 
        type: 'GET',
        data: { page: page, action: action, id: id },
        success: function(response) {
            $('#modalFormContent').html(response); // Cargar el formulario dentro del modal
            $('#editModal').modal('show'); 

            $('#editModal').off('hidden.bs.modal').on('hidden.bs.modal', () => {
                console.log('Modal cerrado');
                if (typeof onClose === 'function') {
                    console.log('Modal cerrado callback');
                    onClose();
                }
              });            
        },
        error: function(xhr, status, error) {
            console.error('Error al obtener el formulario:', status, error);
        }
    });
}


async function instalador_update(id)
{
    const params = new URLSearchParams();

    params.append("id", id);
    params.append("nombre", document.getElementById("nombre").value);
    params.append("asp", document.getElementById("asp").value);

//    alert(params);

    try
    {
        page   = 'instalador',
        action = 'instalador_update'

        const response = await fetch(`mainframe.php?page=${page}&action=${action}`, {
            method: 'POST',
            headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
            body: params.toString()            
        });

        if (!response.ok) { throw new Error(`HTTP error! status: ${response.status}`); }

        const data = await response.json();
        if (data.status === 'success')
        {
            hideModal();
        }
        else 
        {
            console.error(data.message);            
        }
    }
    catch (error) {
        console.error('Error:', error);
    }
}

async function instalador_delete(p)
{
    try
    {
        const confirmDelete = confirm("Are you sure to delete this instalador?" + p.id);
        if (!confirmDelete) {
            return; 
        }

        const page   = 'instalador';
        const action = 'instalador_delete';

        const response = await fetch(`mainframe.php?page=${page}&action=${action}&id=${p.id}`);
        if (!response.ok) { 
            throw new Error(`HTTP error! status: ${response.status}`); 
        }

        const data = await response.json();
        if (data.status === 'success')
        {
             instalador_loadData();                
        }
        else {
             console.error('Error:', error); 
            }
    }
    catch (error) {
        console.error('Error:', error);
    }
}

function hideModal() {
//    alert("hideModal1")
    $('#editModal').modal('hide'); // Usar el método de Bootstrap
    instalador_loadData();
}

