<?php

class instalador_model
{
    private $conexion;
    
    public function __construct($conection)
    {
        $this->conexion = $conection;
    }
    
    public function count($filters)
    {
        $sql = " SELECT COUNT(*) AS total";
        $sql .= " FROM instalador";
        $sql .= " WHERE 1=1 ";
        $params = [];
        $types = "";

        $sql .= $this->build_filters($filters, $params, $types);

        try {
            $stmt = UtilSQL::ExecuteQuery($this->conexion, $sql, $params, $types);

            $sqlResult = $stmt->get_result();
            $stmt->close();

            $fila = $sqlResult->fetch_assoc();
            return $fila['total'];
        } catch (Exception $e) {
            return "Error al obtener el total: " . $e->getMessage();
        }
    }


    public function selectAll($filters, $paginar = true, $filtrar =true)
    {
        $sql = " SELECT * ";
        $sql .= " FROM instalador";
        $sql .= " WHERE 1=1 ";
        $params = [];
        $types = "";

        if ($filtrar) {
            $sql .= $this->build_filters($filters, $params, $types);
            $sql .= UtilSQL::build_sort($filters);
        }
        if ($paginar) {
             $sql .= UtilSQL::build_paginacion($filters, $params, $types); 
        }
//        Tools::debugTXT( $sql );

        try {
            $stmt = UtilSQL::executeQuery($this->conexion, $sql, $params, $types);

            $sqlResult = $stmt->get_result();
            $stmt->close();

            $result = [];
            while ($fila = $sqlResult->fetch_assoc()) {
                $result[] = $fila;
            }
            return $result;
        } catch (Exception $e) {
            return "Error al obtener los registros: " . $e->getMessage();
        }
    }


    public function select($id)
    {
        $sql = "SELECT * FROM instalador WHERE id = ?";

        try {
            $stmt = $this->conexion->prepare($sql);
            $stmt->bind_param("i", $id);

            if (!$stmt->execute()) {
                die('Error en la ejecución de la consulta SQL: ' . $stmt->error);
            }

            $sqlResult = $stmt->get_result();
            $stmt->close();

            $result = [];
            while ($fila = $sqlResult->fetch_assoc()) {
                $result[] = $fila;
            }
            return $result;
        } catch (mysqli_sql_exception $e) {
            error_log("Error en consulta SELECT: " . $e->getMessage()); // Guardar en log de errores
            return "Error al obtener el registro: " . $e->getMessage(); // Mensaje amigable para el usuario
        }
    }


    public function lastId()
    {
        $sql = "SELECT * FROM instalador ORDER BY id DESC LIMIT 1";
        $stmt = $this->conexion->prepare($sql);

        if (!$stmt->execute()) {
            die('Error en la ejecución de la consulta SQL: ' . $stmt->error);
        }

        $resultSQL = $stmt->get_result()->fetch_assoc();
        $lastId = isset($resultSQL['id']) ? (int)$resultSQL['id'] : 0;
        $stmt->close();

        return $lastId;  
    }


    public function insert($id, $nombre) {
        
        $sql = "INSERT INTO instalador (id, nombre) VALUES (?,?)";

        $stmt = $this->conexion->prepare($sql);

        if (!$stmt) {
            die('Error en la preparación de la consulta SQL: ' . $this->conexion->error);
        }

        $stmt->bind_param("is", $id, $nombre);

        if (!$stmt->execute()) {
            die('Error al ejecutar la consulta SQL: ' . $stmt->error);
        }

        // obtiene el ultimo valor autoincrementado
        $newId = $this->conexion->insert_id;

        $stmt->close();
        return $newId;
    }


    public function delete($id) {
        
        $sql = "DELETE FROM instalador WHERE id = ? ";
        $stmt = $this->conexion->prepare($sql);

        if (!$stmt) {
            die('Error en la preparación de la consulta SQL: ' . $this->conexion->error);
        }

        $stmt->bind_param("i", $id);
        if (!$stmt->execute()) {
            die('Error al ejecutar la consulta SQL: ' . $stmt->error);
        }

        $stmt->close();
        return true;
    }

    public function update($id, $data) {
        
        $sql = "UPDATE instalador SET 
                nombre = ?, 
                asp = ? 
            WHERE id = ?";

        $stmt = $this->conexion->prepare($sql);
        if (!$stmt) {
            die('Error en la preparación de la consulta SQL: ' . $this->conexion->error);
        }

        $stmt->bind_param(
            "sii",            
            $data['nombre'],
            $data['asp'],
            $id
        );        
        if (!$stmt->execute()) {
            die('Error al ejecutar la consulta SQL: ' . $stmt->error);
        }

        $stmt->close();
        return true;
    }




    private function build_filters($filters, &$params, &$types)
    {
        $sql = "";

        if ( isset($filters['search']) && ($filters['search'] != '') ) {
            $searchValue = $filters['search'];
            $sql .= " AND nombre LIKE ?";
            $params[] = "%" . $searchValue . "%";
            $types .= "s";
        }

        return $sql;
    }


    // devolvemos un array con todos los instaladores, para las vistas del filtro, y edicion
    public function get_instaladores($asp, $includeTodos = true){
        $tmp = $this->selectAll([], false, false);
        

        // filtrar por asp == 1
        if ($asp != -1) {
            $tmp = array_filter($tmp, function($item) use ($asp) {
                return $item['asp'] == $asp;
            });            
        }

        $result = [];

        if ($includeTodos) {
            $result = [
                [
                    'id'     => -1,        // puedes usar -1 o cualquier valor que indique "todos"
                    'value1' => -1,         // o null
                    'text'   => '[ Todos ]'
                ]
            ];
        }

        $index = 0;
        foreach($tmp as $item)
        {
            $result[] =
             [
                'id'     => $index,
                'value1' => $item['id'],
                'text'   => $item['nombre']
             ];
            $index++;
        }

        return $result;
    }


} // class
