<?php

class instalador_view
{
    private $instalador_model;

    public function __construct($container)
    {
        $this->instalador_model      = $container->get('instalador_model');
    }


    public function showFilter($filters ) {  
        $html = "";
        $html .= "<div class='container-fluid filters shadow'>";
        $html .= "<div class='row  mb-2 justify-content-center'>";           
        $html .= util_html_filter::filter_search( 
            'search', 
            $filters['search'],  
            'Search', 
            'filter_instalador');


        $html .= util_html_filter::filter_select(
            'pag_limit', 
            '', 
            util_html_filter::get_limitOptions(), 
            $filters['pag_limit'], 
            'value1', 'text', 'col-sm-1', 'filter_instalador', false);

        $html .= "</div>"; 
        $html .= "</div>"; 
        return $html;
    }


    public function showAll($filters, $result, $level)
    {
        $insertButton =  util_html_button::button('create', 'instalador_insert_button' ); 

        $html = "";
        $html .= "<div class='outer_div shadow'>";
        $html .= "<div class='table-responsive'>";
        $html .= "<table border=1 id='instalador_table' class='table table-striped table-hover' style='font-size:14px; white-space:nowrap;'>";

        $html .= "<thead>";
        $html .= "<tr class='row2'>";
        
        if ($level === 4) { $html .= util_html_table::th($filters, 'id',       'id 4',      'instalador_sort'); }
        $html .= util_html_table::th($filters, 'nombre',   'nombre',   'instalador_sort');
        if ($level === 4) { $html .= util_html_table::th($filters, 'asp',    'asp 4',   'instalador_sort'); }
        $html .= "<th colspan=2 class='text-center'>".$insertButton."</th>";  


        $html .= "</tr>";
        $html .= "</thead>";

        $html .= "<tbody>";
        if (!empty($result) && (is_array($result) || is_iterable($result)))         
        {
            foreach ($result as $row)
            {
                $html .= "<tr class='row2'>";
                if ($level === 4) { $html .= util_html_table::td($row['id']); }
                $html .= util_html_table::td($row['nombre']);
                if ($level === 4) { $html .= util_html_table::td($row['asp']); }

                $editButton =  util_html_button::button('Edit', 'instalador_editButton', ['id' => $row['id']]  ); 
                $deleteButton =  util_html_button::button('Delete', 'instalador_delete', ['id' => $row['id']]  ); 
                $html .= "<td>".$editButton."</td>"; 
                $html .= "<td>".$deleteButton."</td>"; 

                $html .= "</tr>";
            }
            $html .= "</tbody>";
         }

        $html .= "</table>";
        $html .= "</div>";
        $html .= "</div>";

        return $html;
    }


    // formulario de edicion
    // input_text($id, $field, $value, $label, $class, $style)
    // select($data_locked, $data_id, $data_field, $data_action, $options, $valueField, $valueSelected, $textField)
    public function showId($result, $level)
    {
//        print_r($result);

        $output = "";
        $output .= "<div class='container d-flex flex-column align-items-center mt-4'>";

        $output .= "<div class='row'>";
        $output .= "<div class='col-md-6 mb-3'>";
        if ($level === 4) {
            $output .= util_html_form::input_text('id', $result['id'], 'id', '', 'width:300px;');
            $output .= util_html_form::input_text('asp', $result['asp'], 'asp', '', 'width:300px;');
        }
        else 
        {
            $output .= util_html_form::input_text_hidden('id', $result['id'], 'id', '', 'width:300px;');
            $output .= util_html_form::input_text_hidden('asp', $result['asp'], 'asp', '', 'width:300px;');
        }
        $output .= util_html_form::input_text('nombre', $result['nombre'], 'nombre', '', 'width:300px;');
        $output .= "</div>"; 
        $output .= "</div>";

        $output .= "<div class='w-50 text-center'>";        
        $output .= "<button type='button' onclick='instalador_update( {$result['id']} )' class='btn btn-warning'>Update</button>";
        $output .= "</div>"; 

        $output .= "</div>";
        return $output;
    }

} // class
?>