// Estado global de languages
const languagesState = {
    search: '',
    pag_page: 1,
    pag_limit: 10,
    sort_column: '',
    sort_direction: 'ASC',
    filter_servicio: ''
};

// Inizializa el estado desde la URL
function initStateFromUrl() {
    const params = new URLSearchParams(window.location.search);

    languagesState.search             = params.get('search')   || '';
    languagesState.pag_page           = parseInt(params.get('pag_page')) || 1;
    languagesState.pag_limit          = parseInt(params.get('pag_limit')) || 10;
    languagesState.sortColumn         = params.get('sort_column')   || 'nombre_inst';
    languagesState.sortDirection      = params.get('sort_direction') || 'ASC';
    languagesState.filter_servicio    = params.get('filter_servicio') || '';

    // Actualiza inputs en la UI para reflejar el estado
    $('#search').val(languagesState.search);
    $('#pag_limit').val(languagesState.pag_limit);
    $('#filter_servicio').val(languagesState.filter_servicio);
}


// Actualiza URL desde el estado
function updateUrlFromState() {
    const params = new URLSearchParams({
        search:             languagesState.search,
        pag_page:           languagesState.pag_page,
        pag_limit:          languagesState.pag_limit,
        sort_column:        languagesState.sort_column,
        sort_direction:     languagesState.sort_direction,
        filter_servicio:    languagesState.filter_servicio
    });
    history.pushState({}, '', `${window.location.pathname}?${params.toString()}`);
}


// Cargar datos 
async function languages_loadData() {
    updateUrlFromState(); // sincroniza URL (opcional para la URL visible)

    const postData = new URLSearchParams({
        page: 'languages',
        action: 'languages_filter',
        search:             languagesState.search,
        pag_page:           languagesState.pag_page,
        pag_limit:          languagesState.pag_limit,
        sort_column:        languagesState.sort_column,
        sort_direction:     languagesState.sort_direction,
        filter_servicio:    languagesState.filter_servicio
    });

//    alert(postData);

    try {
        const response = await fetch('mainframe.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded'
            },
            body: postData.toString()
        });

        if (!response.ok) throw new Error(`HTTP error! status: ${response.status}`);

        const data = await response.json();

        $('#languages_table').html(data.table);
        $('#languages_pag').html(data.pagination);

        // Ajustar paginación si totalRecords viene en la respuesta
        if (data.totalRecords) {
            const totalPages = Math.max(1, Math.ceil(data.totalRecords / languagesState.pag_limit));
            if (languagesState.pag_page > totalPages) {
                languagesState.pag_page = totalPages;
                languages_loadData();
            }
        }
    } catch (err) {
        console.error('Error al cargar datos:', err);
    }
}


function languages_sort(field, dir) {
    languagesState.sort_column = field;
    languagesState.sort_direction = dir;
    languages_loadData();
}

// Función genérica para actualizar filtros
function languages_updateFilterField(fieldId, fieldValue) {
//    alert(fieldValue );
    languagesState[fieldId] = fieldValue;
    languagesState.pag_page = 1; // reinicia página cuando cambia un filtro
    languages_loadData();       
}


// =============================
// Document Ready
// =============================
$(document).ready(function () {
        // Asegurarse de que debounceTimers exista, si no, inicializarlo
    if (typeof debounceTimers === 'undefined') {
        debounceTimers = {}; // Inicializar si no existe
    }

    initStateFromUrl();
    languages_loadData();

    // evento para los filtros
    $('.filter_languages').on('input', function () {
        const fieldId    = $(this).attr('id'); // Identifica el campo que disparó el evento.
        let fieldValue;

        if ($(this).attr('type') === 'checkbox') {
            fieldValue = $(this).prop('checked') ? 1 : 0;
        } else {
            fieldValue = $(this).val();
        }

//        alert(fieldId + " " + fieldValue);

        clearTimeout(debounceTimers[fieldId]); // Limpia el temporizador anterior para este campo.
        debounceTimers[fieldId] = setTimeout(() => { 
            languages_updateFilterField(fieldId, fieldValue);
        }, 300); // El retraso es de 300 ms. Puedes ajustarlo según sea necesario.
    });

    // evento para paginación
    $(document).on('click', '.pagination-btn', function() {
        const page = parseInt($(this).data('page'));
        if (!isNaN(page)) {
            languagesState.pag_page = page;
            languages_loadData(); // recarga vía AJAX con la nueva página
        }
    });    
});


async function languages_insert_button()
{
    try
    {
        const page   = 'languages';
        const action = 'languages_insert';

        const response = await fetch(`mainframe.php?page=${page}&action=${action}`, { method: 'GET' });
        if (!response.ok) { 
            throw new Error(`HTTP error! status: ${response.status}`); 
        }

        const data = await response.json();
        if (data.status === 'success')
        {
            languages_edit( data.lastId, () => {
                languages_loadData();                
            } );
        }
        else 
        { console.error(data.status); }           
    } 
    catch (error) {
        console.error('Error:', error);
    }
}


function languages_editButton(p)
{
    languages_edit (p.id, () => {
       languages_loadData();            
    });
}

function languages_edit(id, onClose) {
    const page   = 'languages';
    const action = 'languages_edit';

    $.ajax({
        url: 'mainframe.php', 
        type: 'GET',
        data: { page: page, action: action, id: id },
        success: function(response) {
            $('#modalFormContent').html(response); // Cargar el formulario dentro del modal
            $('#editModal').modal('show'); 

            $('#editModal').off('hidden.bs.modal').on('hidden.bs.modal', () => {
                console.log('Modal cerrado');
                if (typeof onClose === 'function') {
                    console.log('Modal cerrado callback');
                    onClose();
                }
              });            
        },
        error: function(xhr, status, error) {
            console.error('Error al obtener el formulario:', status, error);
        }
    });
}


async function languages_update(id)
{
    const params = new URLSearchParams();

    params.append("id", id);
    params.append("servicio", document.getElementById("servicio").value);
    params.append("token", document.getElementById("token").value);
    params.append("es", document.getElementById("es").value);
    params.append("en", document.getElementById("en").value);

//    alert(params);

    try
    {
        page   = 'languages',
        action = 'languages_update'

        const response = await fetch(`mainframe.php?page=${page}&action=${action}`, {
            method: 'POST',
            headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
            body: params.toString()            
        });

        if (!response.ok) { throw new Error(`HTTP error! status: ${response.status}`); }

        const data = await response.json();
        if (data.status === 'success')
        {
            hideModal();
        }
        else 
        {
            console.error(data.message);            
        }
    }
    catch (error) {
        console.error('Error:', error);
    }
}

async function languages_delete(p)
{
    try
    {
        const confirmDelete = confirm("Are you sure to delete this languages?" + p.id);
        if (!confirmDelete) {
            return; 
        }

        const page   = 'languages';
        const action = 'languages_delete';

        const response = await fetch(`mainframe.php?page=${page}&action=${action}&id=${p.id}`);
        if (!response.ok) { 
            throw new Error(`HTTP error! status: ${response.status}`); 
        }

        const data = await response.json();
        if (data.status === 'success')
        {
             languages_loadData();                
        }
        else {
             console.error('Error:', error); 
            }
    }
    catch (error) {
        console.error('Error:', error);
    }
}

function hideModal() {
//    alert("hideModal1")
    $('#editModal').modal('hide'); // Usar el método de Bootstrap
    languages_loadData();
}

