<?php

class languages_view
{
    private $languages_model;
    private $servicios_model;

    public function __construct($container)
    {
        $this->languages_model      = $container->get('languages_model');
        $this->servicios_model      = $container->get('servicios_model');
    }


    public function showFilter($filters ) {  
        $servicios = $this->servicios_model->get_servicios_options(true);
        
        $html = "";
        $html .= "<div class='container-fluid filters shadow'>";
        $html .= "<div class='row  mb-2 justify-content-center'>";           
        $html .= util_html_filter::filter_search( 
            'search', 
            $filters['search'],  
            'Search token', 
            'filter_languages');

        $html .= util_html_filter::filter_select(
            'filter_servicio', 
            'Servicio', 
            $servicios, 
            $filters['filter_servicio'], 
            'value1', 'text', 'col-sm-1', 'filter_languages', false);

        $html .= util_html_filter::filter_select(
            'pag_limit', 
            '', 
            util_html_filter::get_limitOptions(), 
            $filters['pag_limit'], 
            'value1', 'text', 'col-sm-1', 'filter_languages', false);

        $html .= "</div>"; 
        $html .= "</div>"; 
        return $html;
    }


    public function showAll($filters, $result, $level)
    {
        $insertButton =  util_html_button::button('create', 'languages_insert_button' ); 

        $html = "";
        $html .= "<div class='outer_div shadow'>";
        $html .= "<div class='table-responsive'>";
        $html .= "<table border=1 id='languages_table' class='table table-striped table-hover' style='font-size:14px; white-space:nowrap;'>";

        $html .= "<thead>";
        $html .= "<tr class='row2'>";
        
        $html .= util_html_table::th($filters, 'id',       'id',      'languages_sort'); 
//        $servicio_str = util_languages::translate('servicio');
        $servicio_str = 'servicio';
        $html .= util_html_table::th($filters, 'servicio',  $servicio_str,   'languages_sort');
        $html .= util_html_table::th($filters, 'token',    'token',   'languages_sort');
        $html .= util_html_table::th($filters, 'es',       'es',      'languages_sort');
        $html .= util_html_table::th($filters, 'en',       'en',      'languages_sort');
        $html .= "<th colspan=2 class='text-center'>".$insertButton."</th>";  


        $html .= "</tr>";
        $html .= "</thead>";

        $html .= "<tbody>";
        if (!empty($result) && (is_array($result) || is_iterable($result)))         
        {
            foreach ($result as $row)
            {
                $html .= "<tr class='row2'>";
                $html .= util_html_table::td($row['id']); 
                $html .= util_html_table::td($row['servicio']);
                $html .= util_html_table::td($row['token']);
                $html .= util_html_table::td($row['es']);
                $html .= util_html_table::td($row['en']);

                $editButton =  util_html_button::button('Edit', 'languages_editButton', ['id' => $row['id']]  ); 
                $deleteButton =  util_html_button::button('Delete', 'languages_delete', ['id' => $row['id']]  ); 
                $html .= "<td>".$editButton."</td>"; 
                $html .= "<td>".$deleteButton."</td>"; 

                $html .= "</tr>";
            }
            $html .= "</tbody>";
         }

        $html .= "</table>";
        $html .= "</div>";
        $html .= "</div>";

        return $html;
    }


    // formulario de edicion
    // input_text($id, $field, $value, $label, $class, $style)
    // select($data_locked, $data_id, $data_field, $data_action, $options, $valueField, $valueSelected, $textField)
    public function showId($result, $level)
    {
        $servicios  = $this->servicios_model->get_servicios_options(false);

//        print_r($result);

        $output = "";
        $output .= "<div class='container d-flex flex-column align-items-center mt-4'>";

        $output .= "<div class='row'>";
        $output .= "<div class='col-md-6 mb-3'>";
        $output .= util_html_form::input_text('id', $result['id'], 'id', '', 'width:300px;');

//        $output .= util_html_form::input_text('servicio', $result['servicio'], 'servicio', '', 'width:300px;');
        $output .= util_html_form::select(
            'servicio', 
            'Servicio',
            $servicios,
            $result['servicio'] 
            );


        $output .= util_html_form::input_text('token', $result['token'], 'token', '', 'width:300px;');
        $output .= util_html_form::input_text('es', $result['es'], 'es', '', 'width:300px;');
        $output .= util_html_form::input_text('en', $result['en'], 'en', '', 'width:300px;');
        $output .= "</div>"; 
        $output .= "</div>";

        $output .= "<div class='w-50 text-center'>";        
        $output .= "<button type='button' onclick='languages_update( {$result['id']} )' class='btn btn-warning'>Update</button>";
        $output .= "</div>"; 

        $output .= "</div>";
        return $output;
    }

} // class
?>