// Estado global de equipos
const usuariosState = {
    search: '',
    pag_page: 1,
    pag_limit: 10,
    sort_column: '',
    sort_direction: 'ASC'
};

// Inizializa el estado desde la URL
function initStateFromUrl() {
    const params = new URLSearchParams(window.location.search);

    usuariosState.search        = params.get('search')   || '';
    usuariosState.pag_page      = parseInt(params.get('pag_page')) || 1;
    usuariosState.pag_limit     = parseInt(params.get('pag_limit')) || 10;
    usuariosState.sortColumn    = params.get('sort_column')   || 'nombre_inst';
    usuariosState.sortDirection = params.get('sort_direction') || 'ASC';

    // Actualiza inputs en la UI para reflejar el estado
    $('#search').val(usuariosState.search);
    $('#pag_limit').val(usuariosState.pag_limit);
}


// Actualiza URL desde el estado
function updateUrlFromState() {
    const params = new URLSearchParams({
        search:         usuariosState.search,
        pag_page:       usuariosState.pag_page,
        pag_limit:      usuariosState.pag_limit,
        sort_column:    usuariosState.sort_column,
        sort_direction: usuariosState.sort_direction
    });
    history.pushState({}, '', `${window.location.pathname}?${params.toString()}`);
}


// Cargar datos 
async function usuarios_loadData() {
    updateUrlFromState(); // sincroniza URL (opcional para la URL visible)

    const postData = new URLSearchParams({
        page: 'usuarios',
        action: 'usuarios_filter',
        search:                   usuariosState.search,
        pag_page:                 usuariosState.pag_page,
        pag_limit:                usuariosState.pag_limit,
        sort_column:              usuariosState.sort_column,
        sort_direction:           usuariosState.sort_direction
    });

    try {
        const response = await fetch('mainframe.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded'
            },
            body: postData.toString()
        });

        if (!response.ok) throw new Error(`HTTP error! status: ${response.status}`);

        const data = await response.json();

        $('#usuarios_table').html(data.table);
        $('#usuarios_pag').html(data.pagination);

        // Ajustar paginación si totalRecords viene en la respuesta
        if (data.totalRecords) {
            const totalPages = Math.max(1, Math.ceil(data.totalRecords / usuariosState.pag_limit));
            if (usuariosState.pag_page > totalPages) {
                usuariosState.pag_page = totalPages;
                usuarios_loadData();
            }
        }
    } catch (err) {
        console.error('Error al cargar datos:', err);
    }
}


function usuarios_sort(field, dir) {
    usuariosState.sort_column = field;
    usuariosState.sort_direction = dir;
    usuarios_loadData();
}

// Función genérica para actualizar filtros
function usuarios_updateFilterField(fieldId, fieldValue) {
//    alert(fieldValue );
    usuariosState[fieldId] = fieldValue;
    usuariosState.pag_page = 1; // reinicia página cuando cambia un filtro
    usuarios_loadData();       
}


// =============================
// Document Ready
// =============================
$(document).ready(function () {
        // Asegurarse de que debounceTimers exista, si no, inicializarlo
    if (typeof debounceTimers === 'undefined') {
        debounceTimers = {}; // Inicializar si no existe
    }

    initStateFromUrl();
    usuarios_loadData();

    // evento para los filtros
    $('.filter_usuarios').on('input', function () {
        const fieldId    = $(this).attr('id'); // Identifica el campo que disparó el evento.
        const fieldValue = $(this).val();
        clearTimeout(debounceTimers[fieldId]); // Limpia el temporizador anterior para este campo.

        debounceTimers[fieldId] = setTimeout(() => { 
            usuarios_updateFilterField(fieldId, fieldValue);
        }, 300); // El retraso es de 300 ms. Puedes ajustarlo según sea necesario.
    });


    // evento para paginación
    $(document).on('click', '.pagination-btn', function() {
        const page = parseInt($(this).data('page'));
        if (!isNaN(page)) {
            usuariosState.pag_page = page;
            usuarios_loadData(); // recarga vía AJAX con la nueva página
        }
    });    
});


async function usuarios_insertButton()
{
    try
    {
        const page   = 'usuarios';
        const action = 'usuarios_insert';

        const response = await fetch(`mainframe.php?page=${page}&action=${action}`, { method: 'GET' });
        if (!response.ok) { 
            throw new Error(`HTTP error! status: ${response.status}`); 
        }

        const data = await response.json();
        if (data.status === 'success')
        {
            usuarios_edit( data.lastId, () => {
                usuarios_loadData();                
            } );
        }
        else 
        { console.error(data.status); }           
    } 
    catch (error) {
        console.error('Error:', error);
    }
}


function usuarios_editButton(p)
{
    usuarios_edit (p.id, () => {
       usuarios_loadData();            
    });
}

function usuarios_edit(id, onClose) {
    const page   = 'usuarios';
    const action = 'usuarios_edit';

    $.ajax({
        url: 'mainframe.php',
        type: 'GET',
        data: { page: page, action: action, id: id },
        success: function(response) {
            $('#modalFormContent').html(response); // Cargar el formulario dentro del modal
            $('#editModal').modal('show'); 

            $('#editModal').off('hidden.bs.modal').on('hidden.bs.modal', () => {
                console.log('Modal cerrado');
                if (typeof onClose === 'function') {
                    console.log('Modal cerrado callback');
                    onClose();
                }
              });            
        },
        error: function(xhr, status, error) {
            console.error('Error al obtener el formulario:', status, error);
        }
    });
}


async function usuarios_update(id)
{
    const params = new URLSearchParams();

    params.append("id", id);
    params.append("user", document.getElementById("user").value);
    params.append("pass", document.getElementById("pass").value);
    params.append("email", document.getElementById("email").value);
    params.append("asp", document.getElementById("asp").value);
    params.append("language", document.getElementById("language").value);
    params.append("comentario", document.getElementById("comentario").value);
//    alert(params);

    try
    {
        page   = 'usuarios',
        action = 'usuarios_update'

        const response = await fetch(`mainframe.php?page=${page}&action=${action}`, {
            method: 'POST',
            headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
            body: params.toString()            
        });

        if (!response.ok) { throw new Error(`HTTP error! status: ${response.status}`); }

        const data = await response.json();
        if (data.status === 'success')
        {
            hideModal();
        }
        else 
        {
            console.error(data.message);            
        }
    }
    catch (error) {
        console.error('Error:', error);
    }
}

async function usuarios_delete(p)
{
    try
    {
        const confirmDelete = confirm("Are you sure to delete this usuario?" + p.id);
        if (!confirmDelete) {
            return; 
        }

        const page   = 'usuarios';
        const action = 'usuarios_delete';
        const id = p.id;

        const response = await fetch(`mainframe.php?page=${page}&action=${action}&id=${id}`);
        if (!response.ok) { 
            throw new Error(`HTTP error! status: ${response.status}`); 
        }

        const data = await response.json();
        if (data.status === 'success')
        {
             usuarios_loadData();                
        }
        else {
             console.error('Error:', error); 
            }
    }
    catch (error) {
        console.error('Error:', error);
    }
}

function hideModal() {
//    alert("hideModal1")
    $('#editModal').modal('hide'); // Usar el método de Bootstrap
    usuarios_loadData();
}
