<?php

class usuarios_model
{
    private $conexion;

    public function __construct($conection)
    {
        $this->conexion = $conection;
    }

    public function count($filters)
    {
        $sql = " SELECT COUNT(*) AS total";
        $sql .= " FROM acl_usuarios";
        $sql .= " WHERE 1=1 ";
        $params = [];
        $types = "";

        $sql .= $this->build_filters($filters, $params, $types);

        try {
            $stmt = UtilSQL::executeQuery($this->conexion, $sql, $params, $types);

            $sqlResult = $stmt->get_result();
            $stmt->close();

            $fila = $sqlResult->fetch_assoc();
            return $fila['total'];
        } catch (Exception $e) {
            return "Error al obtener el total: " . $e->getMessage();
        }
    }


    //  le pasaremos $pag [], para exportar a excel, ya que queremos que nos devuelva
    // tota la tabla aplicando el filtro y el orden pero sin paginar.
    public function selectAll($filters,  $paginar = true, $filtrar = true)
    {
        $sql = " SELECT * ";
        $sql .= " FROM acl_usuarios";
        $sql .= " WHERE 1=1 ";
        $params = [];
        $types = "";

        if ($filtrar) {
            $sql .= $this->build_filters($filters, $params, $types);
            $sql .= UtilSQL::build_sort($filters);
        }
        if ($paginar) {
             $sql .= UtilSQL::build_paginacion($filters, $params, $types); 
        }

        try {
            $stmt = UtilSQL::executeQuery($this->conexion, $sql, $params, $types);

            $sqlResult = $stmt->get_result();
            $stmt->close();

            $result = [];
            while ($fila = $sqlResult->fetch_assoc()) {
                $result[] = $fila;
            }
            return $result;
        } catch (Exception $e) {
            return "Error al obtener los registros: " . $e->getMessage();
        }
    }


    public function select($id_user)
    {
        $sql = "SELECT * FROM acl_usuarios WHERE id = ?";

        try {
            $stmt = $this->conexion->prepare($sql);
            $stmt->bind_param("i", $id_user);

            if (!$stmt->execute()) {
                die('Error en la ejecución de la consulta SQL: ' . $stmt->error);
            }

            $sqlResult = $stmt->get_result();
            $stmt->close();

            $result = [];
            while ($fila = $sqlResult->fetch_assoc()) {
                $result[] = $fila;
            }
            return $result;
        } catch (mysqli_sql_exception $e) {
            error_log("Error en consulta SELECT: " . $e->getMessage()); // Guardar en log de errores
            return "Error al obtener el registro: " . $e->getMessage(); // Mensaje amigable para el usuario
        }
    }


    public function lastId()
    {
        $sql = "SELECT id FROM acl_usuarios ORDER BY id DESC LIMIT 1";
        $stmt = $this->conexion->prepare($sql);

        if (!$stmt->execute()) {
            die('Error en la ejecución de la consulta SQL: ' . $stmt->error);
        }

        $resultSQL = $stmt->get_result()->fetch_assoc();
        $lastId = isset($resultSQL['id']) ? (int)$resultSQL['id'] : 0;
        $stmt->close();

        return $lastId;  
    }


    // obtiene las instalaciones de un usuario
    public function get_instalaciones_iduser($id_user)
    {
        $sql = "SELECT * FROM vista_usuarios_instalaciones WHERE id_user = ?";

        try {
            $stmt = $this->conexion->prepare($sql);
            $stmt->bind_param("i", $id_user);

            if (!$stmt->execute()) {
                die('Error en la ejecución de la consulta SQL: ' . $stmt->error);
            }

            $sqlResult = $stmt->get_result();
            $stmt->close();

            $result = [];
            while ($fila = $sqlResult->fetch_assoc()) {
                $result[] = $fila;
            }
            return $result;
        } catch (mysqli_sql_exception $e) {
            error_log("Error en consulta SELECT: " . $e->getMessage()); // Guardar en log de errores
            return "Error al obtener el registro: " . $e->getMessage(); // Mensaje amigable para el usuario
        }
    }

    // obtiene las instalaciones de un usuario
    public function get_servicios_iduser($id_user)
    {
        $sql = "SELECT * FROM vista_usuarios_servicios WHERE id_user = ?";

        try {
            $stmt = $this->conexion->prepare($sql);
            $stmt->bind_param("i", $id_user);

            if (!$stmt->execute()) {
                die('Error en la ejecución de la consulta SQL: ' . $stmt->error);
            }

            $sqlResult = $stmt->get_result();
            $stmt->close();

            $result = [];
            while ($fila = $sqlResult->fetch_assoc()) {
                $result[] = $fila;
            }
            return $result;
        } catch (mysqli_sql_exception $e) {
            error_log("Error en consulta SELECT: " . $e->getMessage()); // Guardar en log de errores
            return "Error al obtener el registro: " . $e->getMessage(); // Mensaje amigable para el usuario
        }
    }



    
    public function insert($user)
    {
        $sql = "INSERT INTO acl_usuarios (user) VALUES (?)";

        $stmt = $this->conexion->prepare($sql);

        if (!$stmt) {
            die('Error en la preparación de la consulta SQL: ' . $this->conexion->error);
        }

        $stmt->bind_param("s", $user);

        if (!$stmt->execute()) {
            die('Error al ejecutar la consulta SQL: ' . $stmt->error);
        }

        // obtiene el ultimo valor autoincrementado
        $newId = $this->conexion->insert_id;

        $stmt->close();
        return $newId;
    }

    public function delete($id)
    {
        $sql = "DELETE FROM acl_usuarios WHERE id = ? ";
        $stmt = $this->conexion->prepare($sql);

        if (!$stmt) {
            die('Error en la preparación de la consulta SQL: ' . $this->conexion->error);
        }

        $stmt->bind_param("i", $id);
        if (!$stmt->execute()) {
            die('Error al ejecutar la consulta SQL: ' . $stmt->error);
        }

        $stmt->close();
        return true;
    }

    public function update($id, $data)
    {
        $sql = "UPDATE acl_usuarios SET 
            user = ?, 
            pass = ?, 
            email = ?, 
            remember_token = ?,
            comentario = ?,
            `language` = ?,  
            asp = ?  
            WHERE id = ?";
        $stmt = $this->conexion->prepare($sql);
        if (!$stmt) {
            die('Error en la preparación de la consulta SQL: ' . $this->conexion->error);
        }

        $stmt->bind_param(
            "ssssssii", 
            $data['user'], 
            $data['pass'], 
            $data['email'], 
            $data['remember_token'],
            $data['comentario'],
            $data['language'],
            $data['asp'],
            $id
        );
        if (!$stmt->execute()) {
            die('Error al ejecutar la consulta SQL: ' . $stmt->error);
        }

        $stmt->close();
        return true;
    }
    

    private function build_filters($filters, &$params, &$types)
    {
        $sql = "";

        if ( isset($filters['search']) &&  $filters['search']!= '') {
            $searchValue = $filters['search'];
            $sql .= " AND user LIKE ?";
            $params[] = "%" . $searchValue . "%";
            $types .= "s";
        }
        return $sql;
    }


    public function get_usuarios_servicios ($id_user, $servicio)
    {
        $sql = "SELECT * FROM vista_usuarios_servicios 
        WHERE id_user = ? AND servicio = ?";

        try {
            $stmt = $this->conexion->prepare($sql);
            $stmt->bind_param("is", $id_user, $servicio);

            if (!$stmt->execute()) {
                die('Error en la ejecución de la consulta SQL: ' . $stmt->error);
            }

            $sqlResult = $stmt->get_result();
            $stmt->close();

            if ($fila = $sqlResult->fetch_assoc()) {
                return $fila; // retornamos la fila completa como array asociativo
            } else {
                return null; // no se encontró nada
            }

            /*
            if ($fila = $sqlResult->fetch_assoc()) {
               return $fila['level']; // devolvemos solo el campo
            } else {
                return null; // no se encontró nada
            }
            */
        } catch (mysqli_sql_exception $e) {
            error_log("Error en consulta SELECT: " . $e->getMessage()); // Guardar en log de errores
            return "Error al obtener el registro: " . $e->getMessage(); // Mensaje amigable para el usuario
        }
    }



    public function get_level_servicio($id_user, $servicio){
        $usuario_servicio   = $this->get_usuarios_servicios($id_user, $servicio );
        return $usuario_servicio['level'];
    }



} // class
