<?php

class usuarios_view
{
        private $usuarios_model;

    public function __construct($container) {
        $this->usuarios_model = $container->get('usuarios_model');
    }

    public function showFilter($filters )
    {
        $html = "";
        $html .= "<div class='container-fluid filters shadow'>";
        $html .= "<div class='row  mb-2 justify-content-center'>";    
        $html .= util_html_filter::filter_search( 
            'search', 
            $filters['search'],  
            'Search Instalacion', 
            'filter_usuarios');

        $html .= util_html_filter::filter_select(
            'pag_limit', 
            '', 
            util_html_filter::get_limitOptions(), 
            $filters['pag_limit'], 
            'value1', 'text', 'col-sm-1', 'filter_usuarios', false);

        $html .= "</div>"; 
        $html .= "</div>"; 
        return $html;
    }


    public function showAll($filters, $result, $level)
    {
//        Tools::DebugTXT($level);
        $insertButton =  UtilHTML::createButton('create', 'usuarios_insertButton' );      

        $html = "";
        $html .= "<div class='outer_div shadow'>";
        $html .= "<div class='table-responsive'>";
        $html .= "<table border=1 id='usuarios_table' class='table table-striped table-hover' style='font-size:14px; white-space:nowrap;'>";

        $html .= "<thead>";
        $html .= "<tr class='row2'>";

        $html .= util_html_table::th($filters, 'id',  'Id',     'usuarios_sort');
        $html .= util_html_table::th($filters, 'user',  'User',     'usuarios_sort');
        $html .= util_html_table::th($filters, 'email',  'Email',     'usuarios_sort');
        $html .= util_html_table::th($filters, 'pass',  'Pass',     'usuarios_sort');
        $html .= util_html_table::th($filters, 'ts',  'ts',     'usuarios_sort');
        $html .= util_html_table::th($filters, 'asp',  'asp',     'usuarios_sort');
        $html .= util_html_table::th($filters, 'language',  'Language',     'usuarios_sort');
        $html .= util_html_table::th($filters, 'comentario',  'Comentario',     'usuarios_sort');
        if ($level === 4) { $html .= "<th colspan=2 class='text-center'>".$insertButton."</th>"; }

        $html .= "</tr>";
        $html .= "</thead>";

        $html .= "<tbody>";
        if (!empty($result) && (is_array($result) || is_iterable($result)))         
        {
            foreach ($result as $row)
            {
                $html .= "<tr class='row2'>";

                $html .= util_html_table::td($row['id']);
                $html .= util_html_table::td($row['user']);
                $html .= util_html_table::td($row['email']);
                $html .= util_html_table::td($row['pass']);
                $html .= util_html_table::td($row['ts']);
                $html .= util_html_table::td($row['asp']);
                $html .= util_html_table::td($row['language']);
                $html .= util_html_table::td($row['comentario']);

                $editButton     =  util_html_button::button('Edit', 'usuarios_editButton', ['id' => $row['id']]  ); 
                $deleteButton   =  util_html_button::button('Delete', 'usuarios_delete', ['id' => $row['id']]  ); 
                if ($level === 4) { $html .= "<td>".$editButton."</td>"; }
                if ($level === 4) { $html .= "<td>".$deleteButton."</td>"; }

                $html .= "</tr>";
            }
            $html .= "</tbody>";
         }

        $html .= "</table>";
        $html .= "</div>";
        $html .= "</div>";

        return $html;
    }


    public function showId($result)
    {
        $output = "";
        $output .= "<div class='container d-flex flex-column align-items-center mt-4'>";

        //public static function input_text($id, $field, $value, $label, $class, $style)
        $output .= util_html_form::input_text('user', $result['user'], 'User');
        $output .= util_html_form::input_text('pass', $result['pass'], 'Password');
        $output .= util_html_form::input_text('email', $result['email'], 'Email');
        $output .= util_html_form::input_text('asp', $result['asp'], 'Asp');
        $output .= util_html_form::input_text('language', $result['language'], 'Language');
        $output .= util_html_form::input_text('comentario', $result['comentario'], 'Comentario');

        $output .= "<div class='w-50 text-center'>";        
        $output .= "<button type='button' onclick='usuarios_update( {$result['id']} )' class='btn btn-warning'>Update</button>";
        $output .= "</div>"; 

        $output .= "</div>";
        return $output;
    }


    /*
    public function show_usuario($data)
    {
        $html = "";
        $html .= "<div class='outer_div shadow'>";
        $html .= "<div class='table-responsive'>";
        $html .= "<table border=1 id='table_barcos' class='table table-striped table-hover' style='font-size:14px; white-space:nowrap;'>";

        $html .= "<thead>";
        $html .= "<tr>";
        $html .= util_html_table::th2('usuario' );
        $html .= util_html_table::th2('email');
        $html .= util_html_table::th2('token');
        $html .= "</tr>";
        $html .= "</thead>";

        $html .= "<tbody>";
        $html .= "<tr>";
        $html .= util_html_table::td($data['user'] );
        $html .= util_html_table::td($data['email']);
        $html .= util_html_table::td($data['remember_token']);
        $html .= "</tr>";
        $html .= "</tbody>";

        $html .= "</table>";
        $html .= "</div>";
        $html .= "</div>";

        return $html;
    }


    public function show_servicios($data)
    {
        //        print_r($data);
        $html = "";
        $html .= "<div class='outer_div shadow'>";
        $html .= "<div class='table-responsive'>";
        $html .= "<table border=1 id='table_barcos' class='table table-striped table-hover' style='font-size:14px; white-space:nowrap;'>";

        $html .= "<thead>";
        $html .= "<tr>";
        $html .= util_html_table::th2('id_user' );
        $html .= util_html_table::th2('id_servicio');
        $html .= util_html_table::th2('servicio');
        $html .= util_html_table::th2('nombre');
        $html .= util_html_table::th2('url');
        $html .= util_html_table::th2('comment');
        $html .= "</tr>";
        $html .= "</thead>";

        $html .= "<tbody>";
        foreach($data as $item)
        {
            $html .= "<tr>";
            $html .= util_html_table::td($item['id_user'] );
            $html .= util_html_table::td($item['id_servicio']);
            $html .= util_html_table::td($item['servicio']);
            $html .= util_html_table::td($item['servicio_nombre']);
            $html .= util_html_table::td($item['servicio_url']);
            $html .= util_html_table::td($item['servicio_comment']);
            $html .= "</tr>";
        }
        $html .= "</tbody>";


        $html .= "</table>";
        $html .= "</div>";
        $html .= "</div>";

        return $html;
    }


        public function show_instalaciones($data)    {
        //        print_r($data);
        $html = "";
        $html .= "<div class='outer_div shadow'>";
        $html .= "<div class='table-responsive'>";
        $html .= "<table border=1 id='table_barcos' class='table table-striped table-hover' style='font-size:14px; white-space:nowrap;'>";

        $html .= "<thead>";
        $html .= "<tr>";
        $html .= util_html_table::th2('id_user' );
        $html .= util_html_table::th2('id_instalacion');
        $html .= util_html_table::th2('instalacion_name');
        $html .= "</tr>";
        $html .= "</thead>";

        $html .= "<tbody>";
        foreach($data as $item)
        {
        //            $instalacion = util_html_button::button('edit', 'instalacion_edit', $item['id_instalacion']);

            $html .= "<tr>";
            $html .= util_html_table::td($item['id_user'] );
            $html .= util_html_table::td($item['id_instalacion']);
            $html .= util_html_table::td($item['instalacion_name']);
//            $html .= "<td>".$instalacion."</td>";
            $html .= "</tr>";
        }
        $html .= "</tbody>";


        $html .= "</table>";
        $html .= "</div>";
        $html .= "</div>";

        return $html;
    }
    */




} // class
?>