<?php
// container_setup.php
require_once __DIR__ . '/core/container.php';
require_once __DIR__ . '/core/autoload.php';
require_once __DIR__ . '/core/AppConfig.php';

    require_once __DIR__ . '/core/config.php';
    require_once __DIR__ . '/core/UtilRender.php';
    require_once __DIR__ . '/core/UtilHTML.php';
    require_once __DIR__ . '/core/util_html_table.php';
    require_once __DIR__ . '/core/util_html_filter.php';
    require_once __DIR__ . '/core/util_html_button.php';
    require_once __DIR__ . '/core/util_html_form.php';
    require_once __DIR__ . '/core/UtilMysql.php'; // mysql y otras funciones
    require_once __DIR__ . '/core/UtilParams.php'; 
    require_once __DIR__ . '/core/UtilPaginacion.php'; 
    require_once __DIR__ . '/core/Util.php'; 
    require_once __DIR__ . '/core/UtilFechas.php'; 
    require_once __DIR__ . '/core/UtilExcel.php';            
    require_once __DIR__ . '/core/class_mysql.php';
    require_once __DIR__ . '/core/UtilSQL.php';
    require_once __DIR__ . '/core/util_languages.php';


    
    $c = configure_container();
    configure_appConfig();
    

    // Tools::Debug
    $document_root = $_SERVER['DOCUMENT_ROOT'];
    include_once $document_root . '/clases/toolsPHP.php';

    // parametros globales

    $P = array_merge($_GET, $_POST);

    $page = (isset($P['page'])) ? $P['page'] : 'nada';
    $page = strtolower($page);  

    $action = (isset($P['action'])) ? $P['action'] : 'nada';
    $action = strtolower($action);    

    $id_user = $_SESSION['usuarioData']['id'];


//    print_r($P);


    // usuario login
    $usuario_model       = $c->get('usuarios_model');
    $usuario    = $usuario_model->select($id_user)[0];
    $username   = $usuario['user'];
    $asp        = $usuario['asp'];
    $language   = $usuario['language'];
    $action     = isset($P['action'])   ? UtilParams::sanitizeString($P['action']) : 'instalacion_showAll';
    $params       = array_merge($_GET, $_POST);

    // inicializamo la clase static util_languages
    $languages_model       = $c->get('languages_model');
    util_languages::setModel ( $languages_model );
    util_languages::setLanguage ( $language );
    


    // configura el contenedor de dependencias //
    // Model solo recibe DB
    // View recibe el model
    // Controller recibe model, view y contenedor (si necesita otros servicios)
    function configure_container(){
        $c = new Container();
        $c->set('db', function($c){ return new AuthDatabase(); });

        $c->set('log_web_model', function($c)          { return new log_web_model($c->get('db')->conexion); }   );

        $c->set('instalacion_model', function($c)      { return new instalacion_model($c->get('db')->conexion); }   );
        $c->set('instalacion_view', function($c)       { return new instalacion_view($c); });
        $c->set('instalacion_controller', function($c) { return new instalacion_controller($c); });

        $c->set('equipos_model', function($c)          { return new equipos_model($c->get('db')->conexion); });
        $c->set('equipos_view', function($c)           { return new equipos_view($c); });
        $c->set('equipos_controller', function($c)     { return new equipos_controller($c); });

        $c->set('usuarios_model', function($c)         { return new usuarios_model($c->get('db')->conexion); });
        $c->set('usuarios_view', function($c)          { return new usuarios_view($c); });
        $c->set('usuarios_controller', function($c)    { return new usuarios_controller($c); });

        $c->set('instalacion_tipo_model', function($c) { return new instalacion_tipo_model($c->get('db')->conexion); });

        $c->set('instalador_model', function($c)      { return new instalador_model($c->get('db')->conexion); });
        $c->set('instalador_view', function($c)       { return new instalador_view($c); });
        $c->set('instalador_controller', function($c) { return new instalador_controller($c); });

        $c->set('servicios_model', function($c)       { return new servicios_model($c->get('db')->conexion); });

        $c->set('languages_model', function($c)      { return new languages_model($c->get('db')->conexion); }   );
        $c->set('languages_view', function($c)       { return new languages_view($c); });
        $c->set('languages_controller', function($c) { return new languages_controller($c); });

        return $c;
    }

    // configura el appConfig con parametros y variables globales 
    function configure_appConfig(){
        $users = [];
        $global = [];

        $AppConfig = AppConfig::getInstance();
        $AppConfig->setConfig('users', $users);
        $AppConfig->setConfig('global', $global);

    }